/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion;

import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceWillRemoveEvent;
import com.atlassian.confluence.impl.space.deletion.SpaceDeletionManager;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.SpaceDeletionBackgroundJobProcessor;
import com.atlassian.confluence.impl.space.deletion.concealing.SpaceConcealer;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.api.EventPublisher;

public class SpaceDeletionManagerImpl
implements SpaceDeletionManager {
    private static final int ALGORITHM_VERSION = 2;
    private final SpaceConcealer spaceConcealer;
    private final SpaceDeletionBackgroundJobProcessor spaceDeletionBackgroundJobProcessor;
    private final EventPublisher eventPublisher;

    public SpaceDeletionManagerImpl(SpaceConcealer spaceConcealer, SpaceDeletionBackgroundJobProcessor spaceDeletionBackgroundJobProcessor, EventPublisher eventPublisher) {
        this.spaceConcealer = spaceConcealer;
        this.spaceDeletionBackgroundJobProcessor = spaceDeletionBackgroundJobProcessor;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void deleteSpaceSync(long spaceId) {
        this.wrapWithSpaceEvents(spaceId, () -> {
            this.spaceConcealer.conceal(spaceId);
            this.spaceConcealer.clearAllCircularReferences(spaceId);
            this.removeSpaceDataSynchronously(spaceId);
        });
    }

    private void wrapWithSpaceEvents(long spaceId, Runnable yield) {
        ProgressMeter progressMeter = new ProgressMeter();
        progressMeter.setPercentage(0, 0);
        Space clonedSpace = this.spaceConcealer.cloneSpace(spaceId);
        this.eventPublisher.publish((Object)new SpaceWillRemoveEvent(this, clonedSpace, progressMeter, 2));
        yield.run();
        progressMeter.setPercentage(100);
        this.eventPublisher.publish((Object)new SpaceRemoveEvent(this, clonedSpace, progressMeter, 2));
    }

    @Override
    public void deleteSpaceAsync(long spaceId) {
        this.wrapWithSpaceEvents(spaceId, () -> {
            this.spaceConcealer.conceal(spaceId);
            this.spaceConcealer.clearAllCircularReferences(spaceId);
            this.createBackgroundTask(spaceId);
        });
    }

    private void createBackgroundTask(long spaceId) {
        this.spaceDeletionBackgroundJobProcessor.startSpaceDeletionInBackground(spaceId);
    }

    private void removeSpaceDataSynchronously(long spaceId) {
        this.spaceDeletionBackgroundJobProcessor.performSpaceDeletionSynchronously(spaceId);
    }
}

