/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.space.SpaceDeletionIterationCompletedEvent;
import com.atlassian.confluence.event.events.space.SpaceDeletionIterationStartedEvent;
import com.atlassian.confluence.impl.backgroundjob.BackgroundJobProcessor;
import com.atlassian.confluence.impl.backgroundjob.BackgroundJobResponse;
import com.atlassian.confluence.impl.backgroundjob.BackgroundJobService;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfoFactory;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateMetadataHelper;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.DeletionResult;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.EntityEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.SpaceContentErasersListBuilder;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.SpaceEraser;
import com.atlassian.confluence.internal.spaces.persistence.SpaceDaoInternal;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.hibernate.SessionFactory;

public class SpaceDeletionBackgroundJobProcessor
implements BackgroundJobProcessor {
    public static final String SPACE_DELETION_SCHEDULE_NEXT_RUN_IN_MINUTES = "space.deletion.schedule.next.run.in.minutes";
    private static final int DEFAULT_SPACE_DELETION_SCHEDULE_NEXT_RUN_IN_MINUTES = 10;
    public static final String SPACE_ID_PARAMETER_NAME = "spaceId";
    public static final String SPACE_DELETION_INITIATOR_USER = "user";
    public static final String SPACE_DELETION_RUN_NUMBER = "runNumber";
    private final BackgroundJobService backgroundJobService;
    private final HibernateMetadataHelper hibernateMetadataHelper;
    private final SpaceContentErasersListBuilder spaceContentErasersListBuilder;
    private final ConfluenceUserDao confluenceUserDao;
    private final Supplier<Instant> timeSupplier;
    private final AccessModeService accessModeService;
    private final EventPublisher eventPublisher;
    private final SpaceDaoInternal spaceDao;
    private final SessionFactory sessionFactory;
    private final TransactionTemplate transactionTemplate;

    public SpaceDeletionBackgroundJobProcessor(BackgroundJobService backgroundJobService, SpaceContentErasersListBuilder spaceContentErasersListBuilder, ConfluenceUserDao confluenceUserDao, SpaceDaoInternal spaceDao, ExportableEntityInfoFactory exportableEntityInfoFactory, SessionFactory sessionFactory, AccessModeService accessModeService, EventPublisher eventPublisher, TransactionTemplate transactionTemplate) {
        this(backgroundJobService, spaceContentErasersListBuilder, confluenceUserDao, spaceDao, new HibernateMetadataHelper(exportableEntityInfoFactory, sessionFactory, false), Instant::now, accessModeService, eventPublisher, sessionFactory, transactionTemplate);
    }

    @VisibleForTesting
    SpaceDeletionBackgroundJobProcessor(BackgroundJobService backgroundJobService, SpaceContentErasersListBuilder spaceContentErasersListBuilder, ConfluenceUserDao confluenceUserDao, SpaceDaoInternal spaceDao, HibernateMetadataHelper hibernateMetadataHelper, Supplier<Instant> timeSupplier, AccessModeService accessModeService, EventPublisher eventPublisher, SessionFactory sessionFactory, TransactionTemplate transactionTemplate) {
        this.backgroundJobService = backgroundJobService;
        this.spaceContentErasersListBuilder = spaceContentErasersListBuilder;
        this.confluenceUserDao = confluenceUserDao;
        this.hibernateMetadataHelper = hibernateMetadataHelper;
        this.timeSupplier = timeSupplier;
        this.accessModeService = accessModeService;
        this.eventPublisher = eventPublisher;
        this.spaceDao = spaceDao;
        this.sessionFactory = sessionFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @PostConstruct
    void register() {
        this.backgroundJobService.registerBackgroundJobProcessor(this);
    }

    @PreDestroy
    void unregister() {
        this.backgroundJobService.unregisterBackgroundJobProcessor(this);
    }

    public Long startSpaceDeletionInBackground(long spaceId) {
        return this.backgroundJobService.addJob(this.getClass(), this.createJobParametersForSpace(spaceId), "Background job deleting space with id " + spaceId, this.getCurrentTime());
    }

    @VisibleForTesting
    public void performSpaceDeletionSynchronously(long spaceId) {
        this.backgroundJobService.runJobSynchronously(this.getClass(), this.createJobParametersForSpace(spaceId));
    }

    private Map<String, Object> createJobParametersForSpace(long spaceId) {
        return Map.ofEntries(Map.entry(SPACE_ID_PARAMETER_NAME, spaceId), Map.entry(SPACE_DELETION_INITIATOR_USER, AuthenticatedUserThreadLocal.get().getKey().getStringValue()), Map.entry(SPACE_DELETION_RUN_NUMBER, 0));
    }

    @Override
    public BackgroundJobResponse process(Long jobId, Map<String, Object> currentJobState, long processingTimeout) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            return this.scheduleNextRun(currentJobState, Optional.of(Integer.parseInt(System.getProperty(SPACE_DELETION_SCHEDULE_NEXT_RUN_IN_MINUTES, String.valueOf(10)))));
        }
        long spaceId = (Long)currentJobState.get(SPACE_ID_PARAMETER_NAME);
        Space space = (Space)this.transactionTemplate.execute(() -> this.spaceDao.getById(spaceId));
        this.eventPublisher.publish((Object)new SpaceDeletionIterationStartedEvent(this, space, (Long)currentJobState.get(SPACE_DELETION_RUN_NUMBER)));
        BooleanSupplier isDeadlineReached = this.createDeadlineSupplier(processingTimeout);
        ConfluenceUser user = this.confluenceUserDao.findByKey(new UserKey((String)currentJobState.get(SPACE_DELETION_INITIATOR_USER)));
        DeletionResult deletionResult = this.deleteDataFromSpaceAndDependantTables(spaceId, user, currentJobState, isDeadlineReached);
        this.eventPublisher.publish((Object)new SpaceDeletionIterationCompletedEvent(this, space, (Long)currentJobState.get(SPACE_DELETION_RUN_NUMBER), deletionResult.getNumberOfObjects(), deletionResult.isFinished()));
        if (deletionResult.isFinished()) {
            this.spaceDao.removeSpaceFromCache(space.getKey());
            this.sessionFactory.getCache().evictQueryRegions();
            return BackgroundJobResponse.markJobAsFinished();
        }
        long runNumber = (Long)currentJobState.get(SPACE_DELETION_RUN_NUMBER);
        HashMap<String, Object> newMutableJobState = new HashMap<String, Object>(currentJobState);
        newMutableJobState.put(SPACE_DELETION_RUN_NUMBER, runNumber + 1L);
        return this.scheduleNextRun(Map.copyOf(newMutableJobState), Optional.empty());
    }

    private DeletionResult deleteDataFromSpaceAndDependantTables(long spaceId, ConfluenceUser initiator, Map<String, Object> currentJobState, BooleanSupplier isDeadlineReached) {
        Map<Class<?>, EntityEraser> allErasersByClass = this.spaceContentErasersListBuilder.createAllErasers(this.hibernateMetadataHelper.getAllEntitiesForSpaceDeletion(), initiator, isDeadlineReached);
        SpaceEraser spaceEraser = (SpaceEraser)allErasersByClass.get(Space.class);
        return spaceEraser.deleteSpaceAndAllDependantEntities(spaceId, currentJobState);
    }

    private BackgroundJobResponse scheduleNextRun(Map<String, Object> currentJobState, Optional<Integer> scheduleTimesInMinutes) {
        return scheduleTimesInMinutes.map(minutes -> BackgroundJobResponse.scheduleNextRun(ChronoUnit.MINUTES, minutes, currentJobState)).orElseGet(() -> BackgroundJobResponse.scheduleNextRunNow(currentJobState));
    }

    private BooleanSupplier createDeadlineSupplier(long processingTimeout) {
        long start = this.getCurrentTime().toEpochMilli();
        long deadline = start + processingTimeout;
        return () -> this.getCurrentTime().toEpochMilli() >= deadline;
    }

    private Instant getCurrentTime() {
        return this.timeSupplier.get();
    }
}

