/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao;

import com.atlassian.confluence.impl.hibernate.DataAccessUtils;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawData;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpaceContentDeletionDao {
    private final SessionFactory sessionFactory;
    private final PlatformTransactionManager transactionManager;

    public SpaceContentDeletionDao(SessionFactory sessionFactory, PlatformTransactionManager transactionManager) {
        this.sessionFactory = sessionFactory;
        this.transactionManager = transactionManager;
    }

    public List<DbRawData> runNativeSelectQuery(String query, Map<String, ?> paramMap, String referencedColumnName, String dependantColumnName, int limit) {
        return (List)this.doInTransaction(tx -> {
            NamedParameterJdbcTemplate template = this.getNamedParameterJdbcTemplate();
            template.getJdbcTemplate().setMaxRows(limit);
            List dbProperties = template.queryForList(query, paramMap);
            return dbProperties.stream().map(properties -> new DbRawData(properties.get(referencedColumnName), properties.get(dependantColumnName))).toList();
        }, true);
    }

    public <T extends DbRawData> List<T> runNativeSelectQuery(String query, Map<String, ?> paramMap, int limit, RowMapper<T> rowMapper) {
        return (List)this.doInTransaction(tx -> {
            NamedParameterJdbcTemplate template = this.getNamedParameterJdbcTemplate();
            template.getJdbcTemplate().setMaxRows(limit);
            return template.query(query, paramMap, rowMapper);
        }, true);
    }

    public int runNativeUpdateQuery(String query, Map<String, ?> paramMap, Class entityClass) {
        return (Integer)this.doInTransaction(tx -> {
            try {
                NamedParameterJdbcTemplate template = this.getNamedParameterJdbcTemplate();
                Integer n = template.update(query, paramMap);
                return n;
            }
            finally {
                if (entityClass != null) {
                    this.sessionFactory.getCache().evictEntityData(entityClass);
                }
            }
        }, false);
    }

    private NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        DataSource dataSource = DataAccessUtils.getJdbcTemplate(this.sessionFactory.getCurrentSession()).getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException("dataSource is empty");
        }
        return new NamedParameterJdbcTemplate(dataSource);
    }

    private <T> T doInTransaction(TransactionCallback<T> callback, boolean readOnly) {
        DefaultTransactionAttribute transactionAttribute = new DefaultTransactionAttribute(3);
        if (readOnly) {
            transactionAttribute.setReadOnly(true);
        }
        return (T)new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionAttribute).execute(callback);
    }
}

