/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao;

import com.atlassian.confluence.impl.backuprestore.helpers.TableAndFieldNameValidator;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawData;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawDataForContentTable;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.SpaceContentDeletionDao;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.DeletionResult;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;

public class SpaceDeletionSqlScriptsRunner {
    static final int MAX_ID_PARTITION_SIZE = Integer.getInteger("confluence.fast-space-deletion.partition-size", 1000);
    private final SpaceContentDeletionDao spaceDeletionDao;

    public SpaceDeletionSqlScriptsRunner(SpaceContentDeletionDao spaceDeletionDao) {
        this.spaceDeletionDao = spaceDeletionDao;
    }

    public List<DbRawData> getDbLinks(String parentIdColumnName, String tableName, String idColumnName, Collection<Long> ids, int queryLimit) {
        String sql = String.format("SELECT %s, %s FROM %s WHERE %s IN (:ids)", TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(parentIdColumnName), TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(idColumnName), TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(tableName), TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(parentIdColumnName));
        ArrayList fullListOfDbLinks = Lists.newArrayList();
        for (List currentIdsBatch : Lists.partition(new ArrayList<Long>(ids), (int)MAX_ID_PARTITION_SIZE)) {
            fullListOfDbLinks.addAll(this.spaceDeletionDao.runNativeSelectQuery(sql, Map.of("ids", currentIdsBatch), parentIdColumnName, idColumnName, queryLimit));
        }
        return fullListOfDbLinks;
    }

    public List<DbRawDataForContentTable> getDbLinksFromContentTable(String parentIdColumnName, Collection<Long> ids, int queryLimit) {
        return this.getDbLinksFromContentTable(parentIdColumnName, ids, false, queryLimit);
    }

    public List<DbRawDataForContentTable> getDbLinksFromContentTable(String parentIdColumnName, Collection<Long> ids, boolean onlyTopLevelPages, int queryLimit) {
        String sql = String.format("SELECT %1$s, CONTENTID, CONTENTTYPE, PREVVER AS ACTIVE_VERSION FROM CONTENT WHERE %1$s IN (:ids)" + (onlyTopLevelPages ? " AND PARENTID IS NULL" : ""), TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(parentIdColumnName));
        RowMapper<DbRawDataForContentTable> rowMapper = new RowMapper<DbRawDataForContentTable>(){

            public DbRawDataForContentTable mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new DbRawDataForContentTable(rs.getLong(1), rs.getLong(2), rs.getString(3), SpaceDeletionSqlScriptsRunner.this.getLongValue(rs, 4));
            }
        };
        ArrayList fullListOfDbLinks = Lists.newArrayList();
        for (List currentIdsBatch : Lists.partition(new ArrayList<Long>(ids), (int)MAX_ID_PARTITION_SIZE)) {
            fullListOfDbLinks.addAll(this.spaceDeletionDao.runNativeSelectQuery(sql, Map.of("ids", currentIdsBatch), queryLimit, rowMapper));
        }
        return fullListOfDbLinks;
    }

    private Long getLongValue(ResultSet rs, int columnIndex) throws SQLException {
        long value = rs.getLong(columnIndex);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    public DeletionResult deleteRecords(String referencingColumnName, String tableName, Collection<Long> ids, Class entityClass) {
        if (ids.isEmpty()) {
            return DeletionResult.finishedResults();
        }
        DeletionResult deletionResult = DeletionResult.finishedResults();
        for (List currentIdsBatch : Lists.partition(new ArrayList<Long>(ids), (int)MAX_ID_PARTITION_SIZE)) {
            String sql = String.format("DELETE FROM %s WHERE %s IN (:ids)", TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(tableName), TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(referencingColumnName));
            deletionResult = deletionResult.merge(DeletionResult.finishedResults(this.spaceDeletionDao.runNativeUpdateQuery(sql, Map.of("ids", currentIdsBatch), entityClass)));
        }
        return deletionResult;
    }
}

