/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.impl.pages.attachments.filesystem.AttachmentDataFileSystem;
import com.atlassian.confluence.impl.pages.attachments.filesystem.model.AttachmentRef;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawData;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawDataForContentTable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentFileEraser {
    private static final Logger log = LoggerFactory.getLogger(AttachmentFileEraser.class);
    @VisibleForTesting
    static final AttachmentRef.Container FAKE_CONTAINER = new AttachmentRef.Container(){

        @Override
        public long getId() {
            return 0L;
        }

        @Override
        public Optional<AttachmentRef.Space> getSpace() {
            return Optional.empty();
        }
    };
    private final AttachmentDataFileSystem attachmentDataFileSystem;

    public static AttachmentRef lightAttachmentRef(final long lastVersionId) {
        return new AttachmentRef(){

            @Override
            public long getId() {
                return lastVersionId;
            }

            @Override
            public AttachmentRef.Container getContainer() {
                throw new UnsupportedOperationException("Light attachment ref does not support containers. Is V3 filesystem still used?");
            }

            @Override
            public int getVersion() {
                return -1;
            }

            public String toString() {
                return "Attachment with id " + this.getId();
            }
        };
    }

    public AttachmentFileEraser(AttachmentDataFileSystem attachmentDataFileSystem) {
        this.attachmentDataFileSystem = attachmentDataFileSystem;
    }

    public void deleteAttachmentFilesIfApplicable(Collection<DbRawDataForContentTable> contentRecords) {
        List<Long> eligibleIds = contentRecords.stream().filter(link -> "ATTACHMENT".equals(link.getContentType()) && link.getActiveVersionId() == null).map(DbRawData::getDependantId).toList();
        for (Long id : eligibleIds) {
            log.trace("Deleting the attachment file (including all historical versions) with id {}", (Object)id);
            this.attachmentDataFileSystem.deleteAllAttachmentVersions(AttachmentFileEraser.lightAttachmentRef(id), FAKE_CONTAINER);
        }
    }
}

