/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawData;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawDataForContentTable;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.SpaceDeletionSqlScriptsRunner;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.AncestorsEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.AttachmentFileEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.BucketPropertySetItemEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.DeletionResult;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.EntityEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.GenericEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.TableFieldHavingForeignKey;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.misc.SpaceDeletionEventSender;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentEntityObjectEraser
implements EntityEraser {
    private static final Logger log = LoggerFactory.getLogger(ContentEntityObjectEraser.class);
    private static final String TABLE_NAME = "CONTENT";
    private static final String ID_COLUMN_NAME = "CONTENTID";
    private static final int PROCESSING_BATCH_SIZE = 100;
    private static final int QUERY_LIMIT = Integer.getInteger("confluence.space-deletion.content-eraser.query-limit", 10000);
    private final BooleanSupplier isDeadlineReached;
    private final ConfluenceUser initiator;
    private final SpaceDeletionSqlScriptsRunner spaceDeletionSqlScriptsRunner;
    private final AttachmentFileEraser attachmentFileEraser;
    private final AncestorsEraser ancestorsEraser;
    private final BucketPropertySetItemEraser bucketPropertySetItemEraser;
    private final SpaceDeletionEventSender spaceDeletionEventSender;
    private final GenericEraser simpleContentEntityGenericEraser;

    public ContentEntityObjectEraser(BooleanSupplier isDeadlineReached, ConfluenceUser initiator, SpaceDeletionSqlScriptsRunner spaceDeletionSqlScriptsRunner, Collection<ExportableEntityInfo> exportableContentEntityInfos, Collection<TableFieldHavingForeignKey> dependantFieldsWithEntities, Map<Class<?>, EntityEraser> allErasers, AttachmentFileEraser attachmentFileEraser, AncestorsEraser ancestorsEraser, BucketPropertySetItemEraser bucketPropertySetItemEraser, SpaceDeletionEventSender spaceDeletionEventSender) {
        this.isDeadlineReached = isDeadlineReached;
        this.spaceDeletionSqlScriptsRunner = spaceDeletionSqlScriptsRunner;
        this.attachmentFileEraser = attachmentFileEraser;
        this.ancestorsEraser = ancestorsEraser;
        this.bucketPropertySetItemEraser = bucketPropertySetItemEraser;
        this.spaceDeletionEventSender = spaceDeletionEventSender;
        this.initiator = initiator;
        ExportableEntityInfo entityInfo = exportableContentEntityInfos.iterator().next();
        this.simpleContentEntityGenericEraser = new GenericEraser(isDeadlineReached, spaceDeletionSqlScriptsRunner, entityInfo, spaceDeletionEventSender, dependantFieldsWithEntities, allErasers);
    }

    @Override
    public Class<?> getEntityClass() {
        return ContentEntityObject.class;
    }

    @Override
    public DeletionResult deleteDataRecursively(String columnName, Collection<Long> ids) {
        if (this.isDeadlineReached.getAsBoolean()) {
            return DeletionResult.notFinishedResults();
        }
        DeletionResult currentDeletionResult = DeletionResult.finishedResults();
        do {
            Set<DbRawDataForContentTable> contentToSpacesLinks;
            if ((contentToSpacesLinks = this.getTopLevelContentObjects(columnName, ids)).isEmpty()) {
                log.debug("All content records have been deleted.");
                break;
            }
            currentDeletionResult = currentDeletionResult.merge(this.deleteRecordsInContentTableRecursivelyInBatches(contentToSpacesLinks));
        } while (!this.isDeadlineReached.getAsBoolean() && !currentDeletionResult.isFinished());
        return currentDeletionResult;
    }

    private DeletionResult deleteRecordsInContentTableRecursively(Set<DbRawDataForContentTable> contentToParentLinksToDelete) {
        if (this.isDeadlineReached.getAsBoolean()) {
            return DeletionResult.notFinishedResults();
        }
        List<Long> currentContentRecordIdsToDelete = contentToParentLinksToDelete.stream().map(DbRawData::getDependantId).toList();
        if (currentContentRecordIdsToDelete.isEmpty()) {
            return DeletionResult.finishedResults();
        }
        Set<DbRawDataForContentTable> allDirectDependantContentObjects = this.getAllDirectDependants(currentContentRecordIdsToDelete);
        DeletionResult deletionResult = this.deleteRecordsInContentTableRecursivelyInBatches(allDirectDependantContentObjects);
        if (!deletionResult.isFinished()) {
            return deletionResult;
        }
        this.spaceDeletionEventSender.sendContentEvents(contentToParentLinksToDelete, this.initiator);
        this.attachmentFileEraser.deleteAttachmentFilesIfApplicable(contentToParentLinksToDelete);
        deletionResult = deletionResult.merge(this.simpleContentEntityGenericEraser.removeOtherDependantsRecursively(currentContentRecordIdsToDelete));
        if (deletionResult.isFinished()) {
            this.ancestorsEraser.deleteAncestorRecords(currentContentRecordIdsToDelete);
            this.bucketPropertySetItemEraser.deleteDataRecursively(currentContentRecordIdsToDelete);
            deletionResult = deletionResult.merge(this.deleteContentObjects(currentContentRecordIdsToDelete));
        }
        return deletionResult;
    }

    DeletionResult deleteRecordsInContentTableRecursivelyInBatches(Set<DbRawDataForContentTable> contentToParentLinksToDelete) {
        if (this.isDeadlineReached.getAsBoolean()) {
            return DeletionResult.notFinishedResults();
        }
        DeletionResult deletionResult = DeletionResult.finishedResults();
        for (int processedSize = 0; processedSize < contentToParentLinksToDelete.size(); processedSize += 100) {
            Set<DbRawDataForContentTable> contentToParentLinksToDeleteBatch = contentToParentLinksToDelete.stream().skip(processedSize).limit(100L).collect(Collectors.toSet());
            deletionResult = deletionResult.merge(this.deleteRecordsInContentTableRecursively(contentToParentLinksToDeleteBatch));
        }
        return deletionResult;
    }

    private Set<DbRawDataForContentTable> getAllDirectDependants(List<Long> parentContentIds) {
        Set<String> possibleParentReferences = Set.of("PREVVER", "PAGEID", "PARENTID", "PARENTCCID", "PARENTCOMMENTID");
        HashSet<DbRawDataForContentTable> dependantLinks = new HashSet<DbRawDataForContentTable>();
        for (String parentColumnName : possibleParentReferences) {
            dependantLinks.addAll(this.spaceDeletionSqlScriptsRunner.getDbLinksFromContentTable(parentColumnName, parentContentIds, QUERY_LIMIT));
        }
        return dependantLinks;
    }

    private DeletionResult deleteContentObjects(List<Long> recordIdsToDelete) {
        return this.spaceDeletionSqlScriptsRunner.deleteRecords(ID_COLUMN_NAME, TABLE_NAME, recordIdsToDelete, this.getEntityClass());
    }

    private Set<DbRawDataForContentTable> getTopLevelContentObjects(String spaceIdColumnName, Collection<Long> spaceIds) {
        return new HashSet<DbRawDataForContentTable>(this.spaceDeletionSqlScriptsRunner.getDbLinksFromContentTable(spaceIdColumnName, spaceIds, true, QUERY_LIMIT));
    }
}

