/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers;

import java.util.Objects;

public class DeletionResult {
    public static final boolean HAS_FINISHED = true;
    public static final boolean NOT_FINISHED_YET = false;
    final int numberOfObjects;
    final boolean finished;

    public DeletionResult(int numberOfObjects, boolean finished) {
        this.numberOfObjects = numberOfObjects;
        this.finished = finished;
    }

    public static DeletionResult notFinishedResults() {
        return new DeletionResult(0, false);
    }

    public static DeletionResult notFinishedResults(int numberOfObjects) {
        return new DeletionResult(numberOfObjects, false);
    }

    public static DeletionResult finishedResults() {
        return new DeletionResult(0, true);
    }

    public static DeletionResult finishedResults(int numberOfObjects) {
        return new DeletionResult(numberOfObjects, true);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public DeletionResult merge(DeletionResult otherResults) {
        return new DeletionResult(this.numberOfObjects + otherResults.numberOfObjects, this.finished && otherResults.finished);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletionResult that = (DeletionResult)o;
        return this.numberOfObjects == that.numberOfObjects && this.finished == that.finished;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfObjects, this.finished);
    }

    public String toString() {
        return "DeletionResult{numberOfObjects=" + this.numberOfObjects + ", finished=" + this.finished + "}";
    }
}

