/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers;

import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawData;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.SpaceDeletionSqlScriptsRunner;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.DeletionResult;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.EntityEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.TableFieldHavingForeignKey;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.misc.SpaceDeletionEventSender;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEraser
implements EntityEraser {
    private static final Logger log = LoggerFactory.getLogger(GenericEraser.class);
    static final int QUERY_LIMIT = Integer.getInteger("confluence.space-deletion.generic-eraser.query-limit", 10000);
    private final BooleanSupplier isDeadlineReached;
    private final ExportableEntityInfo exportableEntityInfo;
    private final Collection<TableFieldHavingForeignKey> dependantFieldsWithEntities;
    private final Map<Class<?>, EntityEraser> allErasers;
    private final SpaceDeletionSqlScriptsRunner spaceDeletionSqlScriptsRunner;
    private final SpaceDeletionEventSender spaceDeletionEventSender;

    public GenericEraser(BooleanSupplier isDeadlineReached, SpaceDeletionSqlScriptsRunner spaceDeletionSqlScriptsRunner, ExportableEntityInfo exportableEntityInfo, SpaceDeletionEventSender spaceDeletionEventSender, Collection<TableFieldHavingForeignKey> dependantFieldsWithEntities, Map<Class<?>, EntityEraser> allErasers) {
        this.isDeadlineReached = isDeadlineReached;
        this.spaceDeletionSqlScriptsRunner = spaceDeletionSqlScriptsRunner;
        this.exportableEntityInfo = exportableEntityInfo;
        this.spaceDeletionEventSender = spaceDeletionEventSender;
        this.dependantFieldsWithEntities = dependantFieldsWithEntities;
        this.allErasers = allErasers;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.exportableEntityInfo.getEntityClass();
    }

    @Override
    public DeletionResult deleteDataRecursively(String parentIdColumnName, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return DeletionResult.finishedResults();
        }
        List<DbRawData> links = this.spaceDeletionSqlScriptsRunner.getDbLinks(parentIdColumnName, this.exportableEntityInfo.getTableName(), this.exportableEntityInfo.getId().getSingleColumnName(), ids, QUERY_LIMIT);
        DeletionResult deletionResultsOfDependantObjects = this.removeOtherDependantsRecursively(this.extractChildIds(links));
        log.trace("Data deletion results for dependant objects {} with '{}' column for {} ids: {}", new Object[]{this.exportableEntityInfo.getEntityClass(), parentIdColumnName, ids.size(), deletionResultsOfDependantObjects});
        this.spaceDeletionEventSender.sendEvents(new HashSet<DbRawData>(links), this.exportableEntityInfo.getEntityClass());
        DeletionResult deletionResultsOfTheCurrentEntity = this.deleteRecordsInThisTable(parentIdColumnName, ids);
        log.trace("Data deletion results of the current table {} with {} ids: {}", new Object[]{this.exportableEntityInfo.getEntityClass(), ids.size(), deletionResultsOfTheCurrentEntity});
        return deletionResultsOfDependantObjects.merge(deletionResultsOfTheCurrentEntity);
    }

    private DeletionResult deleteRecordsInThisTable(String parentIdColumnName, Collection<Long> ids) {
        if (this.isDeadlineReached.getAsBoolean()) {
            return DeletionResult.notFinishedResults();
        }
        return this.spaceDeletionSqlScriptsRunner.deleteRecords(parentIdColumnName, this.exportableEntityInfo.getTableName(), ids, this.getEntityClass());
    }

    DeletionResult removeOtherDependantsRecursively(Collection<Long> ids) {
        DeletionResult currentDeletionResult = DeletionResult.finishedResults();
        for (TableFieldHavingForeignKey childFieldAndEntity : this.dependantFieldsWithEntities) {
            if (this.isDeadlineReached.getAsBoolean()) {
                return DeletionResult.notFinishedResults().merge(currentDeletionResult);
            }
            this.validateReferenceToParent(childFieldAndEntity);
            Class<?> childEntityClass = childFieldAndEntity.currentEntityClass();
            EntityEraser childEraser = this.verifyThatTheEraserExists(this.allErasers.get(childEntityClass), childEntityClass);
            currentDeletionResult = currentDeletionResult.merge(childEraser.deleteDataRecursively(childFieldAndEntity.columnName(), ids));
        }
        return currentDeletionResult;
    }

    private EntityEraser verifyThatTheEraserExists(EntityEraser entityEraser, Class<?> childEntityClass) {
        if (entityEraser == null) {
            throw new IllegalStateException("Unable to find eraser for " + String.valueOf(childEntityClass) + " class. Parent entity is " + String.valueOf(this.exportableEntityInfo.getClass()) + ". Space content can't be deleted.");
        }
        return entityEraser;
    }

    private void validateReferenceToParent(TableFieldHavingForeignKey tableFieldHavingForeignKey) {
        if (this.exportableEntityInfo.getClass() == tableFieldHavingForeignKey.currentEntityClass()) {
            throw new IllegalStateException("Generic objects can't have references to themselves. Can't process " + String.valueOf(this.exportableEntityInfo.getEntityClass()));
        }
    }

    private Collection<Long> extractChildIds(Collection<DbRawData> links) {
        return links.stream().map(DbRawData::getDependantId).filter(Objects::nonNull).toList();
    }
}

