/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers;

import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawData;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.SpaceDeletionSqlScriptsRunner;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.DeletionResult;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.EntityEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.GenericEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.TableFieldHavingForeignKey;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.misc.SpaceDeletionEventSender;
import com.atlassian.confluence.pages.templates.PageTemplate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;

public class PageTemplateEraser
implements EntityEraser {
    private final GenericEraser simplePageTemplateGenericEraser;
    private final ExportableEntityInfo exportableEntityInfo;
    private final SpaceDeletionSqlScriptsRunner spaceDeletionSqlScriptsRunner;

    public PageTemplateEraser(BooleanSupplier isDeadlineReached, SpaceDeletionSqlScriptsRunner spaceDeletionSqlScriptsRunner, ExportableEntityInfo exportableEntityInfo, SpaceDeletionEventSender spaceDeletionEventSender, Collection<TableFieldHavingForeignKey> dependantFieldsWithEntities, Map<Class<?>, EntityEraser> allErasers) {
        this.spaceDeletionSqlScriptsRunner = spaceDeletionSqlScriptsRunner;
        this.exportableEntityInfo = exportableEntityInfo;
        this.simplePageTemplateGenericEraser = new GenericEraser(isDeadlineReached, spaceDeletionSqlScriptsRunner, exportableEntityInfo, spaceDeletionEventSender, dependantFieldsWithEntities, allErasers);
    }

    @Override
    public Class<?> getEntityClass() {
        return PageTemplate.class;
    }

    @Override
    public DeletionResult deleteDataRecursively(String columnName, Collection<Long> ids) {
        DeletionResult deletionResult = this.deleteHistoricalPageTemplates(ids);
        return deletionResult.merge(this.simplePageTemplateGenericEraser.deleteDataRecursively(columnName, ids));
    }

    private DeletionResult deleteHistoricalPageTemplates(Collection<Long> spaceIds) {
        List<DbRawData> links = this.spaceDeletionSqlScriptsRunner.getDbLinks("SPACEID", this.exportableEntityInfo.getTableName(), "TEMPLATEID", spaceIds, GenericEraser.QUERY_LIMIT);
        List<DbRawData> linksToHistoricalVersions = this.spaceDeletionSqlScriptsRunner.getDbLinks("PREVVER", this.exportableEntityInfo.getTableName(), "TEMPLATEID", this.extractChildIds(links), GenericEraser.QUERY_LIMIT);
        Collection<Long> idsOfHistoricalPageTemplates = this.extractChildIds(linksToHistoricalVersions);
        this.simplePageTemplateGenericEraser.removeOtherDependantsRecursively(idsOfHistoricalPageTemplates);
        return this.spaceDeletionSqlScriptsRunner.deleteRecords("TEMPLATEID", this.exportableEntityInfo.getTableName(), idsOfHistoricalPageTemplates, this.getEntityClass());
    }

    private Collection<Long> extractChildIds(Collection<DbRawData> links) {
        return links.stream().map(DbRawData::getDependantId).filter(Objects::nonNull).toList();
    }
}

