/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.EntityEraser;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.SpaceContentErasersFactory;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.TableFieldHavingForeignKey;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.synchrony.Events;
import com.atlassian.synchrony.Snapshots;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceContentErasersListBuilder {
    private static final Logger log = LoggerFactory.getLogger(SpaceContentErasersListBuilder.class);
    private final SpaceContentErasersFactory spaceContentErasersFactory;

    public SpaceContentErasersListBuilder(SpaceContentErasersFactory spaceContentErasersFactory) {
        this.spaceContentErasersFactory = spaceContentErasersFactory;
    }

    public Map<Class<?>, EntityEraser> createAllErasers(Collection<ExportableEntityInfo> allEntities, ConfluenceUser initiator, BooleanSupplier isDeadlineReached) {
        ConcurrentHashMap erasers = new ConcurrentHashMap();
        EntityEraser contentTableEraser = this.spaceContentErasersFactory.createContentEraser(isDeadlineReached, initiator, this.getAllContentEntities(allEntities), this.getDependantEntitiesForContentEntityObjects(allEntities), erasers, this.spaceContentErasersFactory.createAttachmentsEraser(), this.spaceContentErasersFactory.createAncestorsEraser(), this.spaceContentErasersFactory.createBucketPropertySetItemEraser());
        erasers.put(ContentEntityObject.class, contentTableEraser);
        for (ExportableEntityInfo entityInfo : allEntities) {
            Class<?> entityClass = entityInfo.getEntityClass();
            if (ContentEntityObject.class.isAssignableFrom(entityClass)) continue;
            log.debug("Found an entity info with class {}", entityClass);
            Collection<TableFieldHavingForeignKey> dependantFieldsWithEntities = this.getDependantEntities(entityClass, allEntities);
            if (Space.class.equals(entityClass)) {
                erasers.put(entityClass, this.spaceContentErasersFactory.createSpaceEraser(isDeadlineReached, entityInfo, dependantFieldsWithEntities, erasers));
                continue;
            }
            if (PageTemplate.class.equals(entityClass)) {
                erasers.put(entityClass, this.spaceContentErasersFactory.createPageTemplateEraser(isDeadlineReached, entityInfo, dependantFieldsWithEntities, erasers));
                continue;
            }
            if (Snapshots.class.equals(entityClass) || Events.class.equals(entityClass)) {
                erasers.put(entityClass, this.spaceContentErasersFactory.createSynchronyTablesEraser(entityInfo));
                continue;
            }
            erasers.put(entityClass, this.spaceContentErasersFactory.createGenericEraser(isDeadlineReached, entityInfo, dependantFieldsWithEntities, erasers));
        }
        return erasers;
    }

    private Collection<ExportableEntityInfo> getAllContentEntities(Collection<ExportableEntityInfo> allEntities) {
        return allEntities.stream().filter(entity -> ContentEntityObject.class.isAssignableFrom(entity.getEntityClass())).toList();
    }

    private Collection<TableFieldHavingForeignKey> getDependantEntitiesForContentEntityObjects(Collection<ExportableEntityInfo> allEntities) {
        HashSet<TableFieldHavingForeignKey> allReferencedFieldsWithEntities = new HashSet<TableFieldHavingForeignKey>();
        allEntities.stream().filter(entity -> ContentEntityObject.class.isAssignableFrom(entity.getEntityClass())).forEach(entity -> allReferencedFieldsWithEntities.addAll(this.getDependantEntities(entity.getEntityClass(), allEntities)));
        return allReferencedFieldsWithEntities;
    }

    @VisibleForTesting
    Collection<TableFieldHavingForeignKey> getDependantEntities(Class<?> targetEntityClass, Collection<ExportableEntityInfo> allEntities) {
        HashSet<TableFieldHavingForeignKey> allReferencedFieldsWithEntities = new HashSet<TableFieldHavingForeignKey>();
        for (ExportableEntityInfo entityInfo : allEntities) {
            if (entityInfo.getEntityClass() == targetEntityClass) continue;
            entityInfo.getFields().stream().filter(f -> f.getReferencedClass() != null).filter(f -> f.getReferencedClass().equals(this.getClassForExportableEntityInfo(targetEntityClass))).forEach(field -> allReferencedFieldsWithEntities.add(new TableFieldHavingForeignKey(field.getSingleColumnName(), this.getClassForExportableEntityInfo(entityInfo.getEntityClass()))));
            if (entityInfo.getId().getReferencedClass() == null || !this.getClassForExportableEntityInfo(entityInfo.getId().getReferencedClass()).equals(this.getClassForExportableEntityInfo(targetEntityClass))) continue;
            allReferencedFieldsWithEntities.add(new TableFieldHavingForeignKey(entityInfo.getId().getSingleColumnName(), this.getClassForExportableEntityInfo(entityInfo.getEntityClass())));
        }
        return allReferencedFieldsWithEntities;
    }

    private Class<?> getClassForExportableEntityInfo(Class<?> entityClass) {
        return ContentEntityObject.class.isAssignableFrom(entityClass) ? ContentEntityObject.class : entityClass;
    }
}

