/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.backgrounddeletion.erasers.misc;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.event.PluginContentRemovedEvent;
import com.atlassian.confluence.content.persistence.CustomContentDao;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.HiddenAttachmentVersionRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.draft.DraftRemovalEvent;
import com.atlassian.confluence.event.events.content.mail.notification.ContentNotificationRemovedEvent;
import com.atlassian.confluence.event.events.content.mail.notification.SpaceNotificationRemovedEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.event.events.template.TemplateRemoveEvent;
import com.atlassian.confluence.impl.event.AttachmentRemovedEvent;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawData;
import com.atlassian.confluence.impl.space.deletion.backgrounddeletion.dao.DbRawDataForContentTable;
import com.atlassian.confluence.internal.labels.persistence.LabelDaoInternal;
import com.atlassian.confluence.internal.notification.persistence.NotificationDaoInternal;
import com.atlassian.confluence.internal.pages.persistence.AttachmentDaoInternal;
import com.atlassian.confluence.internal.pages.persistence.PageDaoInternal;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.persistence.dao.BlogPostDao;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.persistence.dao.PageTemplateDao;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpaceDeletionEventSender {
    private static final Logger log = LoggerFactory.getLogger(SpaceDeletionEventSender.class);
    private final EventPublisher eventPublisher;
    private final AttachmentDaoInternal attachmentDao;
    private final LabelDaoInternal labelDao;
    private final PageDaoInternal pageDao;
    private final BlogPostDao blogPostDao;
    private final PageTemplateDao pageTemplateDao;
    private final NotificationDaoInternal notificationDao;
    private final CustomContentDao customContentDao;
    private final PlatformTransactionManager transactionManager;

    public SpaceDeletionEventSender(EventPublisher eventPublisher, PageDaoInternal pageDao, BlogPostDao blogPostDao, PageTemplateDao pageTemplateDao, AttachmentDaoInternal attachmentDao, LabelDaoInternal labelDao, NotificationDaoInternal notificationDao, CustomContentDao customContentDao, PlatformTransactionManager transactionManager) {
        this.eventPublisher = eventPublisher;
        this.pageDao = pageDao;
        this.blogPostDao = blogPostDao;
        this.pageTemplateDao = pageTemplateDao;
        this.transactionManager = transactionManager;
        this.attachmentDao = attachmentDao;
        this.notificationDao = notificationDao;
        this.labelDao = labelDao;
        this.customContentDao = customContentDao;
    }

    public void sendContentEvents(Set<DbRawDataForContentTable> contentToParentLinksToDelete, ConfluenceUser initiator) {
        this.doInTransaction(tx -> {
            contentToParentLinksToDelete.forEach(id -> this.sendContentEvent((DbRawDataForContentTable)id, initiator));
            return null;
        });
    }

    public void sendEvents(Set<DbRawData> itemsBeingDeleted, Class type) {
        this.doInTransaction(tx -> {
            itemsBeingDeleted.forEach(id -> this.sendEvent((DbRawData)id, type));
            return null;
        });
    }

    private <T> void doInTransaction(TransactionCallback<T> callback) {
        DefaultTransactionAttribute transactionAttribute = new DefaultTransactionAttribute(3);
        new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionAttribute).execute(callback);
    }

    private void sendContentEvent(DbRawDataForContentTable dbRawData, ConfluenceUser initiator) {
        try {
            switch (dbRawData.getContentType()) {
                case "PAGE": {
                    this.sendPageEvent(dbRawData);
                    break;
                }
                case "ATTACHMENT": {
                    this.sendAttachmentEvent(dbRawData, initiator);
                    break;
                }
                case "BLOGPOST": {
                    this.sendBlogEvent(dbRawData);
                    break;
                }
                case "CUSTOM": {
                    this.sendCustomContentEvent(dbRawData);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Error while sending content event for item with id {} for content type {}", new Object[]{dbRawData.getDependantId(), dbRawData.getContentType(), e});
        }
    }

    private void sendEvent(DbRawData itemsToBeDeleted, Class type) {
        try {
            if (Labelling.class.equals((Object)type)) {
                this.sendLabelEvent(itemsToBeDeleted.getDependantId());
            }
            if (PageTemplate.class.equals((Object)type)) {
                this.sendPageTemplateEvent(itemsToBeDeleted.getDependantId());
            }
            if (Notification.class.equals((Object)type)) {
                this.sendNotificationEvent(itemsToBeDeleted.getDependantId());
            }
        }
        catch (Exception e) {
            log.error("Error while sending event for item with id {} for class {}", new Object[]{itemsToBeDeleted.getDependantId(), type.getName(), e});
        }
    }

    private void sendPageEvent(DbRawDataForContentTable dbRawData) {
        Page page = this.pageDao.getPageById(dbRawData.getDependantId());
        if (page != null) {
            if (page.isDraft()) {
                this.eventPublisher.publish((Object)new DraftRemovalEvent(page));
            } else if (dbRawData.getActiveVersionId() == null) {
                this.eventPublisher.publish((Object)new PageRemoveEvent((Object)this, page));
            }
        } else {
            log.warn("Page with id {} was not found. An event will not be sent", (Object)dbRawData.getDependantId());
        }
    }

    private void sendBlogEvent(DbRawDataForContentTable dbRawData) {
        if (dbRawData.getActiveVersionId() != null) {
            return;
        }
        BlogPost blog = this.blogPostDao.getById(dbRawData.getDependantId());
        if (blog != null) {
            this.eventPublisher.publish((Object)new BlogPostRemoveEvent((Object)this, blog));
        } else {
            log.warn("Blog with id {} was not found. An event will not be sent", (Object)dbRawData.getDependantId());
        }
    }

    private void sendCustomContentEvent(DbRawDataForContentTable dbRawData) {
        if (dbRawData.getActiveVersionId() != null) {
            return;
        }
        CustomContentEntityObject customContent = this.customContentDao.getById(dbRawData.getDependantId());
        if (customContent != null) {
            this.eventPublisher.publish((Object)new PluginContentRemovedEvent((Object)this, customContent));
        } else {
            log.warn("Blog with id {} was not found. An event will not be sent", (Object)dbRawData.getDependantId());
        }
    }

    private void sendAttachmentEvent(DbRawDataForContentTable dbRawData, ConfluenceUser initiator) {
        Attachment attachment = this.attachmentDao.getById(dbRawData.getDependantId());
        if (attachment == null) {
            return;
        }
        if (dbRawData.getActiveVersionId() == null) {
            if (attachment.isHidden()) {
                this.eventPublisher.publish((Object)new HiddenAttachmentVersionRemoveEvent((Object)this, attachment, initiator));
            } else {
                this.eventPublisher.publish((Object)new AttachmentRemoveEvent(this, attachment, initiator, true));
            }
        }
        this.eventPublisher.publish((Object)new AttachmentRemovedEvent(List.of(attachment)));
    }

    private void sendLabelEvent(Long id) {
        Labelling labelling = this.labelDao.findLabellingById(id);
        if (labelling != null) {
            this.eventPublisher.publish((Object)new LabelRemoveEvent(labelling.getLabel(), labelling.getLableable()));
        } else {
            log.warn("Labelling with id {} was not found. An event will not be sent", (Object)id);
        }
    }

    private void sendPageTemplateEvent(Long id) {
        PageTemplate template = this.pageTemplateDao.getById(id);
        if (template != null) {
            this.eventPublisher.publish((Object)new TemplateRemoveEvent(this, template));
        } else {
            log.warn("PageTemplate with id {} was not found. An event will not be sent", (Object)id);
        }
    }

    private void sendNotificationEvent(Long id) {
        Notification notification = this.notificationDao.findNotificationById(id);
        if (notification != null) {
            if (notification.isPageNotification()) {
                this.eventPublisher.publish((Object)new ContentNotificationRemovedEvent(this, notification));
            } else if (notification.isSpaceNotification()) {
                this.eventPublisher.publish((Object)new SpaceNotificationRemovedEvent(this, notification));
            } else {
                log.warn("Notification with id {} was not related to content we want to send events for {}", (Object)id, (Object)notification.getType());
            }
        } else {
            log.warn("Notification with id {} was not found. An event will not be sent", (Object)id);
        }
    }
}

