/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.concealing;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.impl.plugin.settings.PluginSettingRepository;
import com.atlassian.confluence.impl.search.IndexerEventPublisher;
import com.atlassian.confluence.impl.space.deletion.concealing.SpaceKeyNameRenamer;
import com.atlassian.confluence.internal.security.SpacePermissionContext;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.internal.spaces.persistence.SpaceDaoInternal;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpaceUpdateTrigger;
import com.atlassian.event.api.EventPublisher;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SpaceConcealer {
    private static final Logger log = LoggerFactory.getLogger(SpaceConcealer.class);
    private final SpaceManagerInternal spaceManager;
    private final SpaceDaoInternal spaceDao;
    private final SpaceKeyNameRenamer spaceKeyNameRenamer;
    private final BandanaPersister bandanaPersister;
    private final PluginSettingRepository pluginSettingRepository;
    private final SpacePermissionManagerInternal spacePermissionManager;
    private final EventPublisher eventPublisher;

    public SpaceConcealer(SpaceManagerInternal spaceManager, SpaceDaoInternal spaceDao, SpaceKeyNameRenamer spaceKeyNameRenamer, BandanaPersister bandanaPersister, PluginSettingRepository pluginSettingRepository, SpacePermissionManagerInternal spacePermissionManager, EventPublisher eventPublisher) {
        this.spaceManager = spaceManager;
        this.spaceDao = spaceDao;
        this.spaceKeyNameRenamer = spaceKeyNameRenamer;
        this.bandanaPersister = bandanaPersister;
        this.pluginSettingRepository = pluginSettingRepository;
        this.spacePermissionManager = spacePermissionManager;
        this.eventPublisher = eventPublisher;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void conceal(long spaceId) {
        StopWatch watch = StopWatch.createStarted();
        log.debug("Concealing for space {} started", (Object)spaceId);
        Space space = this.checkSpaceExists(this.spaceDao.getById(spaceId), spaceId);
        this.removeSpaceFromTheSearchIndex(space);
        this.changeSpaceStatus();
        this.renameAllSpaceRelatedRecordsInBandanaTable(space);
        this.removeSpacePermissions(space);
        this.spaceKeyNameRenamer.renameSpaceKeyAndName(space);
        this.spaceDao.save(space);
        this.spaceDao.removeSpaceFromCache(space.getKey());
        log.debug("Concealing for space {} finished. Duration: {}", (Object)spaceId, (Object)watch);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Space cloneSpace(long spaceId) {
        Space space = this.checkSpaceExists(this.spaceDao.getById(spaceId), spaceId);
        return this.spaceManager.cloneSpaceForRemoveEvent(space);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void clearAllCircularReferences(long spaceId) {
        Space space = this.checkSpaceExists(this.spaceDao.getById(spaceId), spaceId);
        space.setDescription(null);
        space.setHomePage(null);
        space.setSpaceType(SpaceType.GLOBAL);
    }

    private Space checkSpaceExists(Space space, long spaceId) {
        if (space == null) {
            throw new IllegalStateException("Space with id " + spaceId + " not found");
        }
        log.trace("Found space with key {} for space with id {}", (Object)space.getKey(), (Object)spaceId);
        return space;
    }

    private void removeSpacePermissions(Space space) {
        this.spacePermissionManager.removeAllPermissions(space, SpacePermissionContext.builder().updateTrigger(SpaceUpdateTrigger.SPACE_REMOVED).build());
        log.trace("All space permissions records for space {} ({}) were removed.", (Object)space.getKey(), (Object)space.getId());
    }

    private void renameAllSpaceRelatedRecordsInBandanaTable(Space space) {
        this.bandanaPersister.remove((BandanaContext)new ConfluenceBandanaContext(space));
        this.pluginSettingRepository.deleteInBulkByNamespace(space.getKey());
        log.trace("All bandana records or space {} ({}) were removed.", (Object)space.getKey(), (Object)space.getId());
    }

    private void changeSpaceStatus() {
    }

    private void removeSpaceFromTheSearchIndex(Space space) {
        new IndexerEventPublisher(this.eventPublisher).publishCallbackEvent(indexer -> indexer.unIndexSpace(space));
        log.trace("Unindexing event for space {} ({}) was sent.", (Object)space.getKey(), (Object)space.getId());
    }
}

