/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.space.deletion.concealing;

import com.atlassian.confluence.spaces.Space;
import org.apache.commons.lang3.RandomStringUtils;

public class SpaceKeyNameRenamer {
    public static final int RANDOM_SUFFIX_LEN = 10;
    public static final int MAX_SPACE_KEY_LEN = 255;
    public static final String SPACE_NAME_SUFFIX = " (being removed)";

    public void renameSpaceKeyAndName(Space space) {
        String spaceKey = space.getKey();
        String suffix = "_" + RandomStringUtils.insecure().nextAlphanumeric(9);
        String newSpaceKey = this.addSuffix(spaceKey, suffix);
        space.setKey(newSpaceKey);
        space.setName(this.addSuffix(space.getName(), SPACE_NAME_SUFFIX));
    }

    private String addSuffix(String string, String suffix) {
        if (string.length() + suffix.length() < 245) {
            return string + suffix;
        }
        return string.substring(0, 245) + suffix;
    }
}

