/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.spring;

import org.springframework.retry.RetryContext;
import org.springframework.retry.policy.NeverRetryPolicy;

public class FirstOnStackRetryPolicy
extends NeverRetryPolicy {
    private static final long serialVersionUID = 4329089514863670462L;
    private final transient ThreadLocal<Integer> stackDepth = new ThreadLocal();

    public boolean canRetry(RetryContext context) {
        return super.canRetry(context) || this.stackDepth.get() == 1;
    }

    public RetryContext open(RetryContext parent) {
        this.incrementStackDepth();
        return super.open(parent);
    }

    private void incrementStackDepth() {
        if (this.stackDepth.get() == null) {
            this.stackDepth.set(1);
        } else {
            this.stackDepth.set(this.stackDepth.get() + 1);
        }
    }

    public void close(RetryContext context) {
        super.close(context);
        this.decrementStackDepth();
    }

    private void decrementStackDepth() {
        if (this.stackDepth.get() == 1) {
            this.stackDepth.remove();
        } else {
            this.stackDepth.set(this.stackDepth.get() - 1);
        }
    }
}

