/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;

public class LoggingRetryListener
implements RetryListener {
    public static final RetryListener INSTANCE = new LoggingRetryListener();
    private static final Logger log = LoggerFactory.getLogger(LoggingRetryListener.class);

    private LoggingRetryListener() {
    }

    public <T, E extends Throwable> void onSuccess(RetryContext context, RetryCallback<T, E> callback, T result) {
        if (context.getRetryCount() == 0) {
            return;
        }
        log.warn("Retryable method [{}] succeeded (attempt {})!", (Object)callback.getLabel(), (Object)(context.getRetryCount() + 1));
    }

    public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        log.warn("Retryable method [{}] failed with [{}{}] (attempt {})!", new Object[]{callback.getLabel(), throwable.getClass().getName(), throwable.getCause() != null ? " (Cause: %s)".formatted(throwable.getCause().getClass().getName()) : "", context.getRetryCount()});
    }
}

