/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.startup;

import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.impl.startup.ConfluenceStartAnalyticsEventFactory;
import com.atlassian.confluence.util.profiling.TimedAnalytics;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceStartAnalyticsEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceStartAnalyticsEventPublisher.class);
    private final ConfluenceStartAnalyticsEventFactory confluenceStartEventFactory;
    private final EventPublisher eventPublisher;
    private final Executor executor;

    ConfluenceStartAnalyticsEventPublisher(EventPublisher eventPublisher, ConfluenceStartAnalyticsEventFactory confluenceStartEventFactory, Executor executor) {
        this.executor = Objects.requireNonNull(executor);
        this.confluenceStartEventFactory = Objects.requireNonNull(confluenceStartEventFactory);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @PostConstruct
    public void registerForEvents() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterForEvents() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        this.executor.execute(this::tryPublishEvent);
        TimedAnalytics.timedAnalytics().startAt("confluence.profiling.startup.total", Duration.ZERO).close();
    }

    private void tryPublishEvent() {
        try {
            log.info("Publishing confluence.start event");
            this.eventPublisher.publish((Object)this.confluenceStartEventFactory.createConfluenceStartEvent());
        }
        catch (RuntimeException ex) {
            log.warn("Failed to publish confluence.start event", (Throwable)ex);
        }
    }
}

