/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.confluence.impl.struts.MultipartUploadConfigurator;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.struts2.dispatcher.multipart.JakartaMultiPartRequest;

public class ConfluenceJakartaMultiPartRequest
extends JakartaMultiPartRequest {
    private static final String MULTIPART_LIMIT_EXEMPT_PATTERNS = System.getProperty("multipart.limit.exempt.patterns", "/spaces/restore.action.*,/admin/restore.action.*");
    private static final Long MULTIPART_AUTHENTICATED_MAXPARAMLEN = Long.getLong("multipart.authenticated.max.param.length", 100000L);
    private static final Long MULTIPART_AUTHENTICATED_MAXPARTS = Long.getLong("multipart.authenticated.max.parts", 10000L);
    private static final List<Pattern> COMPILED_EXEMPT_PATTERNS = MultipartUploadConfigurator.buildPatternsList((String)MULTIPART_LIMIT_EXEMPT_PATTERNS, (String)",");
    private final Supplier<PermissionEnforcer> permissionEnforcerRef = MemoizingComponentReference.containerComponent("salPermissionEnforcer");
    private final Supplier<MultipartUploadConfigurator> multipartUploadConfiguratorRef = MemoizingComponentReference.containerComponent("multipartUploadConfigurator");

    public void parse(HttpServletRequest request, String saveDir) throws IOException {
        if (this.shouldBlockMultipart(request)) {
            return;
        }
        this.delimitSizeIfExempt(request);
        this.delimitParamsIfAuthorised();
        try {
            super.parse(request, saveDir);
        }
        catch (InvalidPathException e) {
            this.errors.add(this.buildErrorMessage(e.getClass(), e.getMessage(), new Object[0]));
        }
    }

    void delimitSizeIfExempt(HttpServletRequest request) {
        if (this.permissionEnforcerRef.get().isLicensed() && COMPILED_EXEMPT_PATTERNS.stream().anyMatch(pattern -> pattern.matcher(request.getServletPath()).matches())) {
            this.maxSize = -1L;
            this.maxFileSize = -1L;
        }
    }

    void delimitParamsIfAuthorised() {
        if (this.permissionEnforcerRef.get().isLicensedOrLimitedUnlicensedUser()) {
            this.maxStringLength = Math.max(this.maxStringLength, MULTIPART_AUTHENTICATED_MAXPARAMLEN);
            this.maxFiles = Math.max(this.maxFiles, MULTIPART_AUTHENTICATED_MAXPARTS);
        }
    }

    boolean shouldBlockMultipart(HttpServletRequest request) {
        block3: {
            BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager", BootstrapManager.class);
            if (!bootstrapManager.isSetupComplete()) {
                return false;
            }
            try {
                this.permissionEnforcerRef.get().enforceSiteAccess();
            }
            catch (AuthorisationException e) {
                String path = request.getServletPath();
                if (!this.multipartUploadConfiguratorRef.get().getUnauthorisedAllowedPatterns().stream().noneMatch(pattern -> pattern.matcher(path).matches())) break block3;
                return true;
            }
        }
        return false;
    }
}

