/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterface;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.setup.struts.PluginAwareStrutsConfiguration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.struts2.ActionProxy;
import org.apache.struts2.config.Configuration;
import org.apache.struts2.config.ConfigurationManager;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

public class ConfluenceStrutsDispatcher
extends Dispatcher {
    private final ThreadLocal<ActionProxy> actionProxy = new ThreadLocal();
    private static final AtomicReference<ConfluenceStrutsDispatcher> staticRef = new AtomicReference();

    public ConfluenceStrutsDispatcher(ServletContext servletContext, Map<String, String> initParams) {
        super(servletContext, initParams);
    }

    public void init() {
        super.init();
        if (!staticRef.compareAndSet(null, this)) {
            throw new IllegalStateException("ConfluenceStrutsDispatcher cannot be initialized twice");
        }
    }

    static ConfluenceStrutsDispatcher get() {
        return Objects.requireNonNull(staticRef.get());
    }

    protected ConfigurationManager createConfigurationManager(String name) {
        return new ConfigurationManager(this, name){

            protected Configuration createConfiguration(String beanName) {
                return new PluginAwareStrutsConfiguration(beanName);
            }
        };
    }

    public void serviceAction(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws ServletException {
        super.serviceAction(request, response, mapping);
        if (this.actionProxy.get() != null) {
            this.setWebInterfaceContext(this.actionProxy.get().getAction(), request);
        }
        this.actionProxy.remove();
    }

    protected ActionProxy prepareActionProxy(Map<String, Object> extraContext, String actionNamespace, String actionName, String actionMethod) {
        this.actionProxy.set(super.prepareActionProxy(extraContext, actionNamespace, actionName, actionMethod));
        return this.actionProxy.get();
    }

    private void setWebInterfaceContext(Object action, HttpServletRequest request) {
        if (!(action instanceof WebInterface)) {
            return;
        }
        WebInterface webInterface = (WebInterface)action;
        WebInterfaceContext existentWebInterfaceContext = (WebInterfaceContext)request.getAttribute("atlas.webInterfaceContext");
        WebInterfaceContext webInterfaceContext = webInterface.getWebInterfaceContext();
        if (existentWebInterfaceContext != null) {
            webInterfaceContext = this.toDefaultWebInterfaceContext(webInterfaceContext);
            ((DefaultWebInterfaceContext)webInterfaceContext).putAllMissing(existentWebInterfaceContext);
        }
        request.setAttribute("atlas.webInterfaceContext", (Object)webInterfaceContext);
    }

    private DefaultWebInterfaceContext toDefaultWebInterfaceContext(WebInterfaceContext webInterfaceContext) {
        if (webInterfaceContext instanceof DefaultWebInterfaceContext) {
            DefaultWebInterfaceContext cast = (DefaultWebInterfaceContext)webInterfaceContext;
            return cast;
        }
        return DefaultWebInterfaceContext.copyOf(webInterfaceContext);
    }
}

