/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.confluence.struts.StrutsHelper;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.util.FileSize;
import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.MultiPartUtil;
import com.atlassian.struts.multipart.UploadedFile;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.text.TextProvider;
import org.apache.struts2.text.TextProviderFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class StrutsHelperImpl
implements StrutsHelper {
    private static final String STRUTS_SIZE_LIMIT_KEY = "struts.messages.upload.error.FileUploadSizeException";
    private static final String STRUTS_FILE_SIZE_LIMIT_KEY = "struts.messages.upload.error.FileUploadByteCountLimitException";
    private static final String STRUTS_FILE_COUNT_LIMIT_KEY = "struts.messages.upload.error.FileUploadFileCountLimitException";
    private static final String STRUTS_GENERIC_UPLOAD_KEY = "struts.messages.error.uploading";
    private static final String I18N_FILE_SIZE_LIMIT_KEY = "upload.size.limit.exceeded";
    private static final String I18N_REQ_SIZE_LIMIT_KEY = "upload.request.size.limit.exceeded";
    private static final String I18N_PART_LIMIT_KEY = "upload.part.limit.exceeded";
    private static final String I18N_UNEXPECTED_KEY = "upload.unexpected.error";
    private final I18NBeanFactory i18nBeanFactory;
    private final Supplier<TextProvider> textProviderRef;

    private StrutsHelperImpl(I18NBeanFactory i18NBeanFactory, Supplier<TextProvider> textProviderRef) {
        this.i18nBeanFactory = i18NBeanFactory;
        this.textProviderRef = textProviderRef;
    }

    public StrutsHelperImpl(@Qualifier(value="userI18NBeanFactory") I18NBeanFactory i18NBeanFactory, Dispatcher dispatcher) {
        this(i18NBeanFactory, () -> ((TextProviderFactory)dispatcher.getContainer().getInstance(TextProviderFactory.class)).createInstance(StrutsHelperImpl.class));
    }

    @Override
    public AtlassianJakartaMultiPartRequest unwrapMultiPartRequest(HttpServletRequest request) {
        return MultiPartUtil.unwrapMultiPartRequest((HttpServletRequest)request);
    }

    @Override
    public UploadedFile getUploadedFile(HttpServletRequest request, String fileParameterName) throws FileUploadException {
        return MultiPartUtil.getUploadedFile((HttpServletRequest)request, (String)fileParameterName);
    }

    @Override
    public List<UploadedFile> getUploadedFiles(HttpServletRequest request, boolean ignoreMissingFiles) throws FileUploadException {
        return MultiPartUtil.getUploadedFiles((HttpServletRequest)request, (boolean)ignoreMissingFiles);
    }

    @Override
    public List<String> localizeStrutsMessages(Collection<LocalizedMessage> msgErrors) {
        ArrayList<String> strErrors = new ArrayList<String>();
        for (LocalizedMessage msgError : msgErrors) {
            String msgTextKey = msgError.getTextKey();
            Object[] msgArgs = msgError.getArgs();
            String strError = switch (msgTextKey) {
                case STRUTS_SIZE_LIMIT_KEY -> this.getI18nText(I18N_REQ_SIZE_LIMIT_KEY, FileSize.format((Long)((Long)msgArgs[0])));
                case STRUTS_FILE_SIZE_LIMIT_KEY -> this.getI18nText(I18N_FILE_SIZE_LIMIT_KEY, FileSize.format((Long)((Long)msgArgs[2])));
                case STRUTS_FILE_COUNT_LIMIT_KEY -> this.getI18nText(I18N_PART_LIMIT_KEY, msgArgs);
                case STRUTS_GENERIC_UPLOAD_KEY -> this.getI18nText(I18N_UNEXPECTED_KEY, msgArgs);
                default -> this.textProviderRef.get().hasKey(msgTextKey) ? this.textProviderRef.get().getText(msgTextKey, Arrays.asList(msgArgs)) : this.getI18nText(I18N_UNEXPECTED_KEY, msgError.getDefaultMessage());
            };
            strErrors.add(HtmlUtil.htmlEncode(strError));
        }
        return strErrors;
    }

    private String getI18nText(String key, Object ... args) {
        return this.i18nBeanFactory.getI18NBean().getText(key, args);
    }
}

