/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.system.runner;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.impl.system.MaintenanceTaskExecutionException;
import com.atlassian.confluence.impl.system.SystemMaintenanceTaskRegistry;
import com.atlassian.confluence.impl.system.runner.SystemMaintenanceTaskRunner;
import com.atlassian.confluence.impl.system.task.ReIndexMaintenanceTask;
import com.atlassian.confluence.impl.system.task.SystemMaintenanceTaskType;
import com.atlassian.confluence.index.status.ReIndexJob;
import com.atlassian.confluence.index.status.ReIndexJobManager;
import com.atlassian.confluence.index.status.ReIndexStage;
import com.atlassian.confluence.internal.index.EventPublishingReindexProgress;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.search.SearchPlatformConfig;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReIndexMaintenanceTaskRunner
implements SystemMaintenanceTaskRunner<ReIndexMaintenanceTask> {
    private static final Logger log = LoggerFactory.getLogger(ReIndexMaintenanceTaskRunner.class);
    private final SystemMaintenanceTaskRegistry registry;
    private final IndexManager indexManager;
    private final ClusterManager clusterManager;
    private final ReIndexJobManager reIndexJobManager;
    private final SearchPlatformConfig searchPlatformConfig;
    private final EventPublisher eventPublisher;

    public ReIndexMaintenanceTaskRunner(SystemMaintenanceTaskRegistry registry, IndexManager indexManager, ClusterManager clusterManager, ReIndexJobManager reIndexJobManager, SearchPlatformConfig searchPlatformConfig, EventPublisher eventPublisher) {
        this.registry = Objects.requireNonNull(registry);
        this.indexManager = Objects.requireNonNull(indexManager);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.reIndexJobManager = Objects.requireNonNull(reIndexJobManager);
        this.searchPlatformConfig = Objects.requireNonNull(searchPlatformConfig);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @PostConstruct
    public void register() {
        this.registry.register(SystemMaintenanceTaskType.REINDEX, this);
    }

    @PreDestroy
    public void unregister() {
        this.registry.unregister(SystemMaintenanceTaskType.REINDEX);
    }

    @Override
    public void execute(ReIndexMaintenanceTask task) throws MaintenanceTaskExecutionException {
        this.reIndexJobManager.getRunningOrMostRecentReIndex().ifPresentOrElse(currentJob -> {
            if (!currentJob.getId().equals(task.getJobId())) {
                log.error("The task job id {} is different from the persisted job ID {}", (Object)task.getJobId(), (Object)currentJob.getId());
                return;
            }
            if (currentJob.getStage() != ReIndexStage.REBUILDING) {
                log.error("The job id {} is in {} stage, which is not REBUILDING", (Object)task.getJobId(), (Object)currentJob.getStage());
                return;
            }
            if (this.searchPlatformConfig.isSharedIndex()) {
                if (!this.isEnqueuedByCurrentNode(task)) {
                    this.skipCurrentNodeFromJobTracking((ReIndexJob)currentJob);
                    return;
                }
            } else {
                boolean isSiteReIndex = ListUtils.emptyIfNull(task.getSpaceKeys()).isEmpty();
                if (isSiteReIndex) {
                    if (!this.isEnqueuedByCurrentNode(task)) {
                        return;
                    }
                } else {
                    log.info("Running reindexing for Space on every node");
                }
            }
            log.info("Performing reindexing");
            this.indexManager.reIndex(task.getOptions(), task.getSpaceKeys());
        }, () -> log.error("Reindex job not found. It could have been deleted before."));
    }

    private boolean isEnqueuedByCurrentNode(ReIndexMaintenanceTask task) {
        ClusterNodeInformation thisNodeInformation = this.clusterManager.getThisNodeInformation();
        if (!this.clusterManager.isClustered() || thisNodeInformation == null) {
            log.info("Running reindexing in non cluster Environment");
            return true;
        }
        if (thisNodeInformation.getAnonymizedNodeIdentifier().equals(task.getSourceNodeId())) {
            log.info("Running site reindex on current node {}", (Object)task.getSourceNodeId());
            return true;
        }
        log.info("Skip site reindex as current node Id does not match with task's node Id {}", (Object)task.getSourceNodeId());
        return false;
    }

    private void skipCurrentNodeFromJobTracking(ReIndexJob currentJob) {
        if (this.isCurrentNodeTrackedByJob(currentJob)) {
            log.info("Update job to skip current node");
            new EventPublishingReindexProgress(this.eventPublisher, null).reIndexSkipped();
        }
    }

    private boolean isCurrentNodeTrackedByJob(ReIndexJob job) {
        ClusterNodeInformation thisNode = this.clusterManager.getThisNodeInformation();
        if (thisNode == null) {
            return false;
        }
        return job.getNodeStatus(thisNode.getAnonymizedNodeIdentifier()).isPresent();
    }
}

