/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.themes;

import com.atlassian.confluence.impl.themes.ThemeKeyDao;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PluginSettingsThemeKeyDao
implements ThemeKeyDao {
    private static final String THEME_KEY = "theme.key";
    private final PluginSettingsFactory settingsFactory;

    public PluginSettingsThemeKeyDao(PluginSettingsFactory pluginSettingsFactory) {
        this.settingsFactory = pluginSettingsFactory;
    }

    @Override
    public Optional<String> getGlobalThemeKey() {
        Map<String, String> themeSettings = this.getThemeSettings(null);
        return Optional.ofNullable(themeSettings.get(THEME_KEY));
    }

    @Override
    public void setGlobalThemeKey(String themeCompleteKey) {
        Map<String, String> themeSettings = this.getThemeSettings(null);
        if (themeCompleteKey != null) {
            themeSettings.put(THEME_KEY, themeCompleteKey);
        } else {
            themeSettings.remove(THEME_KEY);
        }
        this.setThemeSettings(null, themeSettings);
    }

    @Override
    public Optional<String> getSpaceThemeKey(@Nullable String spaceKey) {
        Map<String, String> themeSettings = this.getThemeSettings(spaceKey);
        return Optional.ofNullable(themeSettings.get(THEME_KEY));
    }

    @Override
    public void setSpaceThemeKey(String spaceKey, String themeKey) {
        Map<String, String> themeSettings = this.getThemeSettings(spaceKey);
        if (themeKey != null) {
            themeSettings.put(THEME_KEY, themeKey);
        } else {
            themeSettings.remove(THEME_KEY);
        }
        this.setThemeSettings(spaceKey, themeSettings);
    }

    private void setThemeSettings(String contextKey, Map<String, String> themeSettings) {
        this.settingsFactory.createSettingsForKey(contextKey).put("atlassian.confluence.theme.settings", themeSettings);
    }

    private Map<String, String> getThemeSettings(String contextKey) {
        return (Map)Objects.requireNonNullElseGet(this.settingsFactory.createSettingsForKey(contextKey).get("atlassian.confluence.theme.settings"), HashMap::new);
    }
}

