/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.themes.persistence;

import com.atlassian.confluence.core.PersistentDecorator;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.dao.support.DataAccessUtils;

class PersistentDecoratorHibernateHelper {
    private final SessionFactory sessionFactory;

    PersistentDecoratorHibernateHelper(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean hasAnyDecorators() {
        return !this.sessionFactory.getCurrentSession().createQuery("from PersistentDecorator").setMaxResults(1).list().isEmpty();
    }

    public List<PersistentDecorator> getDecorators(@Nullable String spaceKey) {
        return Optional.ofNullable(spaceKey).map(this::getDecoratorsBySpace).orElseGet(this::getGlobalDecorators);
    }

    private List<PersistentDecorator> getGlobalDecorators() {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.persistentdecorator_findGlobalDecorators", PersistentDecorator.class).list();
    }

    private List<PersistentDecorator> getDecoratorsBySpace(String spaceKey) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.persistentdecorator_findBySpaceKey", PersistentDecorator.class).setParameter("spaceKey", (Object)spaceKey).list();
    }

    public void saveNewDecorator(PersistentDecorator decorator) {
        this.sessionFactory.getCurrentSession().save((Object)decorator);
    }

    public void removeDecorator(PersistentDecorator decorator) {
        this.sessionFactory.getCurrentSession().delete((Object)decorator);
    }

    private PersistentDecorator getNamedDecorator(@Nullable String spaceKey, String decoratorName) {
        return (PersistentDecorator)DataAccessUtils.singleResult((Collection)PersistentDecoratorHibernateHelper.createDecoratorFetchQuery(spaceKey, decoratorName, this.sessionFactory.getCurrentSession()).list());
    }

    public void updateDecorator(PersistentDecorator decorator) {
        this.getNamedDecorator(decorator.getSpaceKey(), decorator.getName()).setBody(decorator.getBody());
    }

    private static Query<PersistentDecorator> createDecoratorFetchQuery(@Nullable String spaceKey, String decoratorName, Session session) {
        Query query;
        if (StringUtils.isNotEmpty((CharSequence)spaceKey)) {
            query = session.createNamedQuery("confluence.persistentdecorator_findByNameAndSpaceKey", PersistentDecorator.class);
            query.setParameter("spaceKey", (Object)spaceKey);
        } else {
            query = session.createNamedQuery("confluence.persistentdecorator_findGlobalDecoratorByName", PersistentDecorator.class);
        }
        query.setParameter("name", (Object)decoratorName);
        return query;
    }
}

