/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.threadlimiter.analyticsservice;

import com.atlassian.confluence.impl.threadlimiter.analyticsservice.AverageTimeInfo;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MacroViewAnalyticsStorage {
    static final long FAILED_RENDERING_ID = -1L;
    private static final int LOCK_TIMEOUT_MS = 10;
    private final Supplier<Long> timeSupplier;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong macroRenderingIdGenerator = new AtomicLong();
    private final Map<Long, MarcoRenderingInfo> runningMacrosHolder = new ConcurrentHashMap<Long, MarcoRenderingInfo>();
    private final Map<String, AverageTimeInfo> durationsPerMacro = new ConcurrentHashMap<String, AverageTimeInfo>();

    public MacroViewAnalyticsStorage() {
        this(System::currentTimeMillis);
    }

    public MacroViewAnalyticsStorage(Supplier<Long> timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public Map<String, Long> getNumberBusyOfThreadsPerMacro() throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return Collections.emptyMap();
        }
        try {
            Map<String, Long> map = this.runningMacrosHolder.values().stream().map(marcoRenderingInfo -> marcoRenderingInfo.macroName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, Long> extractAverageDurationsPerMacroAndClear() throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return Collections.emptyMap();
        }
        try {
            Map<String, Long> map = this.durationsPerMacro.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AverageTimeInfo)e.getValue()).getAverage()));
            return map;
        }
        finally {
            this.durationsPerMacro.clear();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long registerMacroStart(String macroName) throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return -1L;
        }
        try {
            long renderingId = this.macroRenderingIdGenerator.incrementAndGet();
            this.runningMacrosHolder.put(renderingId, new MarcoRenderingInfo(macroName, this.timeSupplier.get()));
            long l = renderingId;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerMacroStop(long renderingId) throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return;
        }
        try {
            MarcoRenderingInfo marcoRenderingInfo = this.runningMacrosHolder.remove(renderingId);
            if (marcoRenderingInfo != null) {
                this.updateDurationForMacro(marcoRenderingInfo.macroName, this.timeSupplier.get() - marcoRenderingInfo.startRenderingTime);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateDurationForMacro(String macroName, long duration) {
        this.durationsPerMacro.compute(macroName, (macroName1, averageTimeInfo) -> averageTimeInfo != null ? averageTimeInfo.addDuration(duration) : new AverageTimeInfo(duration));
    }

    private static class MarcoRenderingInfo {
        final String macroName;
        final long startRenderingTime;

        public MarcoRenderingInfo(String macroName, long startRenderingTime) {
            this.macroName = macroName;
            this.startRenderingTime = startRenderingTime;
        }
    }
}

