/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.threadlimiter.analyticsservice;

import com.atlassian.confluence.impl.threadlimiter.analyticsservice.AverageTimeInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class SearchRequestsAnalyticsStorage {
    static final long FAILED_RENDERING_ID = -1L;
    private static final int LOCK_TIMEOUT_MS = 10;
    private final Supplier<Long> timeSupplier;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong macroRenderingIdGenerator = new AtomicLong();
    private final Map<Long, Long> currentlyRunningSearchRequests = new ConcurrentHashMap<Long, Long>();
    private final AverageTimeInfo averageDuration = new AverageTimeInfo();

    public SearchRequestsAnalyticsStorage() {
        this(System::currentTimeMillis);
    }

    public SearchRequestsAnalyticsStorage(Supplier<Long> timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public Long getNumberOfBusyThreads() throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return -1L;
        }
        try {
            Long l = this.currentlyRunningSearchRequests.size();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AverageTimeInfo extractAverageDurationAndClear() throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return new AverageTimeInfo(-1L);
        }
        try {
            AverageTimeInfo averageTimeInfo = new AverageTimeInfo(this.averageDuration);
            return averageTimeInfo;
        }
        finally {
            this.averageDuration.clear();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long registerSearchStart() throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return -1L;
        }
        try {
            long renderingId = this.macroRenderingIdGenerator.incrementAndGet();
            this.currentlyRunningSearchRequests.put(renderingId, this.timeSupplier.get());
            long l = renderingId;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSearchStop(long requestProcessingId) throws InterruptedException {
        if (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            return;
        }
        try {
            Long startTime = this.currentlyRunningSearchRequests.remove(requestProcessingId);
            if (startTime != null) {
                this.averageDuration.addDuration(this.timeSupplier.get() - startTime);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

