/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.threadlimiter.analyticsservice;

import com.atlassian.confluence.impl.threadlimiter.analyticsservice.NoopThreadLimiterAnalyticsService;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.LazyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ThreadLimiterAnalyticsService {
    public static final boolean THREAD_LIMITER_DISABLED = Boolean.getBoolean("confluence.thread-limiter.disable");
    public static final Logger log = LoggerFactory.getLogger(ThreadLimiterAnalyticsService.class);
    public static final LazyReference<ThreadLimiterAnalyticsService> threadLimiterAnalyticsServiceRef = new LazyReference<ThreadLimiterAnalyticsService>(){

        protected ThreadLimiterAnalyticsService create() {
            if (THREAD_LIMITER_DISABLED) {
                return new NoopThreadLimiterAnalyticsService();
            }
            try {
                return (ThreadLimiterAnalyticsService)ContainerManager.getComponent((String)"threadLimiterAnalyticsService");
            }
            catch (Exception e) {
                log.error("Unable to retrieve ThreadLimiterAnalyticsService. Analytics for the thread limiter will not be sent.");
                return new NoopThreadLimiterAnalyticsService();
            }
        }
    };

    public static ThreadLimiterAnalyticsService getInstance() {
        ThreadLimiterAnalyticsService threadLimiterAnalyticsService = (ThreadLimiterAnalyticsService)threadLimiterAnalyticsServiceRef.get();
        return threadLimiterAnalyticsService != null ? threadLimiterAnalyticsService : new NoopThreadLimiterAnalyticsService();
    }

    public long onMacroStartRendering(MacroDefinition var1);

    public void onMacroStopRendering(long var1);

    public long onSearchRequestProcessingStart();

    public void onSearchRequestProcessingFinish(long var1);

    public void flushAnalytics();
}

