/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.threadlimiter.analyticsservice;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.impl.threadlimiter.ThreadLimiterStatisticsEvent;
import com.atlassian.confluence.impl.threadlimiter.analyticsservice.AverageTimeInfo;
import com.atlassian.confluence.impl.threadlimiter.analyticsservice.MacroViewAnalyticsStorage;
import com.atlassian.confluence.impl.threadlimiter.analyticsservice.SearchRequestsAnalyticsStorage;
import com.atlassian.confluence.impl.threadlimiter.analyticsservice.ThreadLimiterAnalyticsService;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.event.api.EventPublisher;
import java.util.Map;
import java.util.stream.Collectors;

public class ThreadLimiterAnalyticsServiceImpl
implements ThreadLimiterAnalyticsService {
    private static final int SINGLE_NODE_NAME_HASHCODE = 0;
    private static final int UNDEFINED_NODE_NAME_HASHCODE = -1;
    private final EventPublisher eventPublisher;
    private final MacroViewAnalyticsStorage macroViewAnalyticsStorage;
    private final SearchRequestsAnalyticsStorage searchRequestAnalyticsStorage;
    private final SystemInformationService systemInformationService;
    private final ClusterManager clusterManager;

    public ThreadLimiterAnalyticsServiceImpl(EventPublisher eventPublisher, MacroViewAnalyticsStorage macroViewAnalyticsStorage, SearchRequestsAnalyticsStorage searchRequestAnalyticsStorage, SystemInformationService systemInformationService, ClusterManager clusterManager) {
        this.eventPublisher = eventPublisher;
        this.macroViewAnalyticsStorage = macroViewAnalyticsStorage;
        this.searchRequestAnalyticsStorage = searchRequestAnalyticsStorage;
        this.systemInformationService = systemInformationService;
        this.clusterManager = clusterManager;
    }

    @Override
    public long onMacroStartRendering(MacroDefinition macroDefinition) {
        if (THREAD_LIMITER_DISABLED) {
            return -1L;
        }
        try {
            return this.macroViewAnalyticsStorage.registerMacroStart(macroDefinition.getName());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1L;
        }
    }

    @Override
    public void onMacroStopRendering(long renderingId) {
        if (THREAD_LIMITER_DISABLED) {
            return;
        }
        if (renderingId == -1L) {
            return;
        }
        try {
            this.macroViewAnalyticsStorage.registerMacroStop(renderingId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public long onSearchRequestProcessingStart() {
        if (THREAD_LIMITER_DISABLED) {
            return -1L;
        }
        try {
            return this.searchRequestAnalyticsStorage.registerSearchStart();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1L;
        }
    }

    @Override
    public void onSearchRequestProcessingFinish(long requestProcessingId) {
        if (THREAD_LIMITER_DISABLED) {
            return;
        }
        try {
            this.searchRequestAnalyticsStorage.registerSearchStop(requestProcessingId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void flushAnalytics() {
        if (THREAD_LIMITER_DISABLED) {
            return;
        }
        try {
            Map<Integer, Long> busyThreads = this.macroViewAnalyticsStorage.getNumberBusyOfThreadsPerMacro().entrySet().stream().collect(Collectors.toMap(e -> this.calculateHash((String)e.getKey()), Map.Entry::getValue));
            Map<Integer, Long> durations = this.macroViewAnalyticsStorage.extractAverageDurationsPerMacroAndClear().entrySet().stream().collect(Collectors.toMap(e -> this.calculateHash((String)e.getKey()), Map.Entry::getValue));
            AverageTimeInfo searchAverageDurationInfo = this.searchRequestAnalyticsStorage.extractAverageDurationAndClear();
            this.eventPublisher.publish((Object)new ThreadLimiterStatisticsEvent(this.getNodeNameHash(), this.systemInformationService.getMaxHTTPThreads(), busyThreads, durations, this.searchRequestAnalyticsStorage.getNumberOfBusyThreads(), searchAverageDurationInfo.getCount(), searchAverageDurationInfo.getAverage()));
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
    }

    private Integer getNodeNameHash() {
        if (!this.clusterManager.isClustered()) {
            return 0;
        }
        ClusterNodeInformation clusterNodeInformation = this.clusterManager.getThisNodeInformation();
        return clusterNodeInformation != null ? this.calculateHash(clusterNodeInformation.getAnonymizedNodeIdentifier()) : -1;
    }

    private Integer calculateHash(String textValue) {
        return textValue.hashCode();
    }
}

