/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.tracing;

import com.atlassian.confluence.util.logging.LoggingContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.reporter.Call;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.Sender;

public class LoggingSpanSender
extends Sender {
    private static final Logger log = LoggerFactory.getLogger(LoggingSpanSender.class);

    public Encoding encoding() {
        return Encoding.JSON;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return encodedSpans.stream().mapToInt(bytes -> ((byte[])bytes).length).sum();
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        for (byte[] encodedSpan : encodedSpans) {
            try {
                String spanJson = new String(encodedSpan, StandardCharsets.UTF_8);
                LoggingContext.executeWithContext((String)"trace", writer -> writer.write(spanJson), () -> log.info("Zipkin span"));
            }
            catch (Exception exception) {
                log.error("Failed to decode or log span: {}", (Object)new String(encodedSpan, StandardCharsets.UTF_8), (Object)exception);
            }
        }
        return Call.create(null);
    }
}

