/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.transaction;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ReadOnlyAndReadWriteTransactionConversionTemplate<T> {
    private final PlatformTransactionManager transactionManager;
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyAndReadWriteTransactionConversionTemplate.class);

    public ReadOnlyAndReadWriteTransactionConversionTemplate(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public T executeInReadOnly(Supplier<T> callback) {
        return this.executeInReadOnly(callback, callback);
    }

    public T executeInReadOnly(Supplier<T> inReadOnlyCallback, Supplier<T> notInReadOnlyCallback) {
        if (TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            log.debug("Detected existing read-only transaction");
            return inReadOnlyCallback.get();
        }
        log.debug("Running within a new read-only transaction");
        DefaultTransactionDefinition tranDef = new DefaultTransactionDefinition(3);
        tranDef.setReadOnly(true);
        return (T)new TransactionTemplate(this.transactionManager, (TransactionDefinition)tranDef).execute(status -> notInReadOnlyCallback.get());
    }

    public T executeInReadWrite(Supplier<T> callback) {
        if (TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            log.debug("Running within a readonly transaction, propagating new read/write transaction");
            DefaultTransactionDefinition tranDef = new DefaultTransactionDefinition(3);
            return (T)new TransactionTemplate(this.transactionManager, (TransactionDefinition)tranDef).execute(status -> callback.get());
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug("Detected existing read-write transaction");
            return callback.get();
        }
        log.debug("No active transaction detected, propagating new read/write transaction");
        DefaultTransactionDefinition tranDef = new DefaultTransactionDefinition(3);
        return (T)new TransactionTemplate(this.transactionManager, (TransactionDefinition)tranDef).execute(status -> callback.get());
    }
}

