/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.dmz.user.UserAccessorInternal;
import com.atlassian.confluence.event.events.group.GroupCreateEvent;
import com.atlassian.confluence.event.events.group.GroupRemoveEvent;
import com.atlassian.confluence.event.events.user.UserCreateEvent;
import com.atlassian.confluence.event.events.user.UserDeactivateEvent;
import com.atlassian.confluence.event.events.user.UserReactivateEvent;
import com.atlassian.confluence.event.events.user.UserUpdatedEvent;
import com.atlassian.confluence.impl.user.AtlassianUserQueryHelper;
import com.atlassian.confluence.impl.user.UserPreferencesAccessorInternal;
import com.atlassian.confluence.impl.user.UserProfilePictureAccessorInternal;
import com.atlassian.confluence.impl.user.UserRemover;
import com.atlassian.confluence.impl.user.crowd.CrowdDirectoryEntityHelper;
import com.atlassian.confluence.internal.security.SpacePermissionContext;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.license.exception.LicenseUserLimitExceededException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.SpaceUpdateTrigger;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.confluence.user.GroupMembershipAccessor;
import com.atlassian.confluence.user.GroupResolver;
import com.atlassian.confluence.user.HasBackingUser;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserExistenceChecker;
import com.atlassian.confluence.user.UserManagementOperationFailedException;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.UserVerificationTokenManager;
import com.atlassian.confluence.user.UserVerificationTokenType;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.user.crowd.CrowdUserConversionHelper;
import com.atlassian.confluence.user.crowd.CrowdUserDirectoryHelper;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUser;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.SecureRandomStringUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.EntityValidationException;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.password.Credential;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DefaultUserAccessor
implements UserAccessorInternal {
    private static final int RANDOM_PASSWORD_LENGTH = 22;
    private final int bulkFetchGroupBatchSize = Integer.getInteger("confluence.group.fetch.batch.size", 400);
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAccessor.class);
    private final RepositoryAccessor repositoryAccessor;
    private final SpacePermissionManagerInternal spacePermissionManager;
    private final PersonalInformationManager personalInformationManager;
    private final UserChecker userChecker;
    private final EventPublisher eventPublisher;
    private final ContentPermissionManager contentPermissionManager;
    private final PermissionManager permissionManager;
    private final CrowdService crowdService;
    private final DisabledUserManager disabledUserManager;
    private final ConfluenceUserDao confluenceUserDao;
    private final GlobalSettingsManager globalSettingsManager;
    private final CrowdUserDirectoryHelper crowdUserDirectoryHelper;
    private final UserPreferencesAccessorInternal userPreferencesAccessor;
    private final AtlassianUserQueryHelper atlassianUserQueryHelper;
    private final ConfluenceUserResolver userResolver;
    private final UserProfilePictureAccessorInternal userProfilePictureAccessor;
    private final GroupResolver groupResolver;
    private final GroupMembershipAccessor groupMembershipAccessor;
    private final UserRemover userRemover;
    private final UserExistenceChecker userExistenceChecker;
    private final UserVerificationTokenManager userVerificationTokenManager;
    private final BootstrapManager bootstrapManager;
    private final CrowdDirectoryEntityHelper crowdDirectoryEntityHelper;

    DefaultUserAccessor(RepositoryAccessor repositoryAccessor, SpacePermissionManagerInternal spacePermissionManager, PersonalInformationManager personalInformationManager, UserChecker userChecker, EventPublisher eventPublisher, ContentPermissionManager contentPermissionManager, PermissionManager permissionManager, CrowdService crowdService, DisabledUserManager disabledUserManager, ConfluenceUserDao confluenceUserDao, UserExistenceChecker userExistenceChecker, GlobalSettingsManager globalSettingsManager, CrowdUserDirectoryHelper crowdUserDirectoryHelper, UserVerificationTokenManager userVerificationTokenManager, BootstrapManager bootstrapManager, CrowdDirectoryEntityHelper crowdDirectoryEntityHelper, UserPreferencesAccessorInternal userPreferencesAccessor, AtlassianUserQueryHelper atlassianUserQueryHelper, UserProfilePictureAccessorInternal userProfilePictureAccessor, UserRemover userRemover, GroupResolver groupResolver, GroupMembershipAccessor groupMembershipAccessor, ConfluenceUserResolver userResolver) {
        this.repositoryAccessor = repositoryAccessor;
        this.spacePermissionManager = spacePermissionManager;
        this.personalInformationManager = personalInformationManager;
        this.userChecker = userChecker;
        this.eventPublisher = eventPublisher;
        this.contentPermissionManager = contentPermissionManager;
        this.permissionManager = permissionManager;
        this.crowdService = crowdService;
        this.disabledUserManager = disabledUserManager;
        this.confluenceUserDao = confluenceUserDao;
        this.globalSettingsManager = globalSettingsManager;
        this.crowdUserDirectoryHelper = crowdUserDirectoryHelper;
        this.userPreferencesAccessor = userPreferencesAccessor;
        this.atlassianUserQueryHelper = atlassianUserQueryHelper;
        this.userResolver = userResolver;
        this.userProfilePictureAccessor = userProfilePictureAccessor;
        this.groupResolver = groupResolver;
        this.groupMembershipAccessor = groupMembershipAccessor;
        this.userRemover = userRemover;
        this.userExistenceChecker = userExistenceChecker;
        this.userVerificationTokenManager = userVerificationTokenManager;
        this.bootstrapManager = bootstrapManager;
        this.crowdDirectoryEntityHelper = crowdDirectoryEntityHelper;
    }

    @Override
    public boolean isLicensedToAddMoreUsers() {
        return this.userChecker.isLicensedToAddMoreUsers();
    }

    @Override
    public boolean isUserRemovable(com.atlassian.user.User user) throws EntityException {
        return !this.getUserManager().isReadOnly(user) && this.crowdUserDirectoryHelper.getDirectoriesForUser(user).size() <= 1;
    }

    @Override
    public void addMembership(Group group, com.atlassian.user.User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, group)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.getGroupManager().addMembership(group, user);
        }
        catch (EntityException e) {
            log.error("Failed to add '{}' as a member of '{}'", new Object[]{user.getName(), group.getName(), e});
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
        finally {
            this.userChecker.resetResult();
        }
    }

    @Override
    public boolean removeMembership(Group group, com.atlassian.user.User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, group)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.getGroupManager().removeMembership(group, user);
            boolean bl = true;
            return bl;
        }
        catch (EntityException e) {
            log.error("Failed to remove '{}' as a member of '{}'", new Object[]{user.getName(), group.getName(), e});
            boolean bl = false;
            return bl;
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
        finally {
            this.userChecker.resetResult();
        }
    }

    @Override
    public @Nullable ConfluenceUser getUserByName(String name) {
        return this.userResolver.getUserByName(name);
    }

    @Override
    public @Nullable ConfluenceUser getUserByKey(UserKey key) {
        return this.userResolver.getUserByKey(key);
    }

    @Override
    public boolean isDeletedUser(ConfluenceUser user) {
        return this.confluenceUserDao.isDeletedUser(user);
    }

    @Override
    public boolean isUnsyncedUser(ConfluenceUser user) {
        return this.confluenceUserDao.isUnsyncedUser(user);
    }

    @Override
    public boolean isCrowdManaged(ConfluenceUser user) {
        return !this.isUnsyncedUser(user) && !this.isDeletedUser(user);
    }

    @Override
    public @Nullable ConfluenceUser getExistingUserByKey(UserKey key) {
        return this.userResolver.getExistingUserByKey(key);
    }

    @Override
    public boolean exists(String name) {
        return this.userExistenceChecker.exists(name);
    }

    @Override
    public com.atlassian.user.User addUser(String username, String password, String email, String fullname, String[] groups) {
        com.atlassian.user.User user = this.addUser(username, password, email, fullname);
        if (groups != null) {
            for (String groupName : groups) {
                Group group = this.getGroupCreateIfNecessary(groupName);
                this.addMembership(group, user);
            }
        }
        return user;
    }

    @Override
    public com.atlassian.user.User addUser(String username, String password, String email, String fullname) {
        return this.createUser((com.atlassian.user.User)new DefaultUser(username.toLowerCase(), fullname, email), Credential.unencrypted((String)password));
    }

    @Override
    public void saveUser(com.atlassian.user.User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.getUserManager().saveUser(user);
            this.fireUserEvent(new UserUpdatedEvent(this, user));
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    @Override
    public Group getGroupCreateIfNecessary(String name) {
        Group group = this.getGroup(name);
        if (group == null) {
            group = this.createGroup(name);
        }
        return group;
    }

    @Override
    public void addMembership(String groupName, String username) {
        Group group = this.getGroup(groupName);
        ConfluenceUser user = this.getUserByName(username);
        if (group == null || user == null) {
            log.error("Failed to add '{}' as a member of '{}'", (Object)username, (Object)groupName);
            return;
        }
        this.addMembership(group, user);
    }

    @Override
    public boolean removeMembership(String groupName, String username) {
        Group group = this.getGroup(groupName);
        ConfluenceUser user = this.getUserByName(username);
        if (group == null || user == null) {
            log.error("Failed to remove '{}' as a member of '{}'", (Object)username, (Object)groupName);
            return false;
        }
        return this.removeMembership(group, user);
    }

    @Override
    public ConfluenceUser createUser(com.atlassian.user.User userTemplate, Credential credential) {
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), PermissionManager.TARGET_APPLICATION, com.atlassian.user.User.class)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.userWillBeCreated();
            com.atlassian.user.User createdUser = this.getUserManager().createUser(userTemplate, credential);
            this.userWasCreated(createdUser);
            return (ConfluenceUser)createdUser;
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
    }

    @Override
    public @Nullable ConfluenceUser createUser(UserTemplateWithAttributes userTemplate, Credential password) {
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), PermissionManager.TARGET_APPLICATION, com.atlassian.user.User.class)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.userWillBeCreated();
            if (Credential.NONE.equals((Object)password)) {
                password = this.createRandomCredential();
            }
            if (password.isEncrypted()) {
                throw new IllegalArgumentException("Cannot create a user with an already encrypted credential");
            }
            Object crowdUser = userTemplate.getDirectoryId() <= 0L ? this.crowdService.addUser((UserWithAttributes)userTemplate, password.getValue()) : this.crowdDirectoryEntityHelper.addUser(userTemplate, password.getValue());
            ConfluenceUser canonicalUser = (ConfluenceUser)this.getUserManager().getUser(crowdUser.getName());
            if (canonicalUser instanceof HasBackingUser) {
                HasBackingUser backedUser = (HasBackingUser)((Object)canonicalUser);
                long directoryId = ((EmbeddedCrowdUser)backedUser.getBackingUser()).getDirectoryId();
                if (userTemplate.getDirectoryId() != 0L && directoryId != userTemplate.getDirectoryId()) {
                    return null;
                }
            }
            this.userWasCreated(canonicalUser);
            return canonicalUser;
        }
        catch (DirectoryNotFoundException | InvalidCredentialException | InvalidUserException | OperationFailedException | OperationNotPermittedException | UserAlreadyExistsException | DirectoryPermissionException | EntityException e) {
            throw new InfrastructureException(e);
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
    }

    private Credential createRandomCredential() {
        String randomPassword = SecureRandomStringUtils.getInstance().randomAlphanumericString(22);
        return Credential.unencrypted((String)randomPassword);
    }

    @Override
    public Group addGroup(String groupname) {
        return this.createGroup(groupname.toLowerCase());
    }

    @Override
    public Group createGroup(String groupname) {
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), PermissionManager.TARGET_APPLICATION, Group.class)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            Group group = this.getGroupManager().createGroup(groupname);
            this.fireUserEvent(new GroupCreateEvent(this, group));
            return group;
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
    }

    @Override
    public void removeGroup(Group group) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.REMOVE, group)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.spacePermissionManager.removeAllPermissionsForGroup(group.getName(), SpacePermissionContext.builder().updateTrigger(SpaceUpdateTrigger.GROUP_REMOVED).sendEvents(false).build());
            this.contentPermissionManager.removeAllGroupPermissions(group.getName());
            this.getGroupManager().removeGroup(group);
            this.fireUserEvent(new GroupRemoveEvent(this, group));
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
        finally {
            this.userChecker.resetResult();
        }
    }

    @Override
    public void removeUser(com.atlassian.user.User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.REMOVE, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.userRemover.removeUser(user);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public List<String> getUserNamesWithConfluenceAccess() {
        try (Ticker ignored = Timers.start((String)(this.getClass().getName() + "_getUserNamesWithConfluenceAccess"));){
            HashMap<String, String> activeUserNames = new HashMap<String, String>();
            for (String name : this.crowdDirectoryEntityHelper.getActiveUserNames()) {
                activeUserNames.put(DefaultUserAccessor.normalise(name), name);
            }
            List<SpacePermission> usePermissions = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE");
            TreeSet<String> usernames = new TreeSet<String>();
            for (SpacePermission permission : usePermissions) {
                ConfluenceUser user = permission.getUserSubject();
                if (user != null) {
                    String normalisedName = DefaultUserAccessor.normalise(user.getName());
                    String originalUsernameFromMap = (String)activeUserNames.get(normalisedName);
                    if (originalUsernameFromMap == null) continue;
                    usernames.add(originalUsernameFromMap);
                    continue;
                }
                if (permission.isGroupPermission()) {
                    Group group = this.getGroup(permission.getGroup());
                    if (group == null) {
                        log.info("Could not find group configured with USE permission: {}", (Object)permission.getGroup());
                        continue;
                    }
                    for (String member : this.getMemberNames(group)) {
                        String normalisedName = DefaultUserAccessor.normalise(member);
                        String originalUsernameFromMap = (String)activeUserNames.get(normalisedName);
                        if (originalUsernameFromMap == null) continue;
                        usernames.add(originalUsernameFromMap);
                    }
                    continue;
                }
                log.info("Found USE permission with no associated username or group: {}", (Object)permission);
            }
            List<String> usernameList = List.copyOf(usernames);
            log.debug("Found {} licensed users: {}", (Object)usernameList.size(), usernameList);
            List<String> list = usernameList;
            return list;
        }
    }

    @Override
    public Pager<ConfluenceUser> searchUnsyncedUsers(String searchParam) {
        return new DefaultPager(this.confluenceUserDao.searchUnsyncedUsers(searchParam));
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public int countLicenseConsumingUsers() {
        return this.getUserNamesWithConfluenceAccess().size();
    }

    @Override
    public boolean isDeactivated(String username) {
        return username != null && this.disabledUserManager.isDisabled(username);
    }

    @Override
    public boolean isDeactivated(com.atlassian.user.User user) {
        return user != null && this.disabledUserManager.isDisabled(user);
    }

    @Override
    public void deactivateUser(com.atlassian.user.User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.SET_PERMISSIONS, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.disabledUserManager.disableUser(this.toCrowdUser(user));
            this.userChecker.decrementRegisteredUserCount();
            this.eventPublisher.publish((Object)new UserDeactivateEvent(this, user, true));
        }
        catch (UserManagementOperationFailedException | EntityValidationException e) {
            log.error("Attempt to deactivate user {} unsuccessful: {}", (Object)user.getName(), (Object)((Throwable)e).getMessage());
            throw new UserManagementOperationFailedException((Throwable)e);
        }
    }

    @Override
    public void reactivateUser(com.atlassian.user.User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.SET_PERMISSIONS, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            User crowdUser = this.toCrowdUser(user);
            if (crowdUser == null) {
                throw new UserNotFoundException(user.getName());
            }
            this.disabledUserManager.enableUser(crowdUser);
            this.userChecker.incrementRegisteredUserCount();
            this.eventPublisher.publish((Object)new UserReactivateEvent(this, user, true));
        }
        catch (UserNotFoundException e) {
            log.error("Attempt to reactivate user {} unsuccessful. User not found: {}", (Object)user.getName(), (Object)e.getMessage());
        }
        catch (UserManagementOperationFailedException | EntityValidationException e) {
            log.error("Attempt to reactivate user {} unsuccessful: {}", (Object)user.getName(), (Object)((Throwable)e).getMessage());
            throw new UserManagementOperationFailedException((Throwable)e);
        }
    }

    @Override
    public void reactivateUserLocally(com.atlassian.user.User user) throws EntityValidationException, UserManagementOperationFailedException {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.SET_PERMISSIONS, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.disabledUserManager.disableEnableUserLocally(this.toCrowdUser(user), true);
            this.userChecker.incrementRegisteredUserCount();
            this.eventPublisher.publish((Object)new UserReactivateEvent(this, user, true));
        }
        catch (UserManagementOperationFailedException | EntityValidationException e) {
            log.error("Attempt to reactivate user {} unsuccessful. User not found: {}", (Object)user.getName(), (Object)((Throwable)e).getMessage());
            throw e;
        }
    }

    @Override
    public boolean isReadOnly(com.atlassian.user.User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        try {
            return this.getUserManager().isReadOnly(user);
        }
        catch (EntityException e) {
            log.error("Error determining if User [{}] is readonly", (Object)user, (Object)e);
            return false;
        }
    }

    @Override
    public boolean isReadOnly(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        try {
            return this.getGroupManager().isReadOnly(group);
        }
        catch (EntityException e) {
            log.error("Error determining if Group [{}] is readonly", (Object)group, (Object)e);
            return false;
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public ProfilePictureInfo getUserProfilePicture(@Nullable com.atlassian.user.User user) {
        return this.userProfilePictureAccessor.getUserProfilePicture(user);
    }

    @Override
    public void setUserProfilePicture(com.atlassian.user.User user, Attachment attachment) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.userProfilePictureAccessor.setUserProfilePicture(user, attachment);
    }

    @Override
    public void setUserProfilePicture(com.atlassian.user.User user, String imagePath) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.userProfilePictureAccessor.setUserProfilePicture(user, imagePath);
    }

    @Override
    @Deprecated
    public List<String> getAllDefaultGroupNames() {
        return List.of(this.globalSettingsManager.getGlobalSettings().getDefaultUsersGroup(), "confluence-administrators");
    }

    @Override
    @Deprecated
    public String getNewUserDefaultGroupName() {
        return this.globalSettingsManager.getGlobalSettings().getDefaultUsersGroup();
    }

    @Override
    public boolean isSuperUser(com.atlassian.user.User user) {
        Group confluenceAdmins = this.getGroup("confluence-administrators");
        return this.hasMembership(confluenceAdmins, user) && !this.isDeactivated(user);
    }

    @Override
    @Transactional(readOnly=true)
    public @NonNull UserPreferences getUserPreferences(@Nullable ConfluenceUser user) {
        return this.userPreferencesAccessor.getUserPreferences(user);
    }

    @Override
    public List<String> getGroupNames(com.atlassian.user.User user) {
        if (user == null) {
            return Collections.emptyList();
        }
        return this.getGroupNamesForUserName(user.getName());
    }

    @Override
    public List<String> getGroupNamesForUserName(String userName) {
        if (userName == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Iterable)this.crowdService.search((com.atlassian.crowd.embedded.api.Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1)));
    }

    @Override
    public List<Group> getGroupsAsList() {
        return PagerUtils.toList(this.getGroups());
    }

    @Override
    public Group getGroup(String name) {
        return this.groupResolver.getGroup(name);
    }

    @Override
    public Pager<String> getMemberNames(Group group) {
        return this.groupMembershipAccessor.getMemberNames(group);
    }

    @Override
    public List<String> getMemberNamesAsList(Group group) {
        return this.groupMembershipAccessor.getMemberNamesAsList(group);
    }

    @Override
    public Iterable<ConfluenceUser> getMembers(Group group) {
        return this.getMembers(group, 0);
    }

    @Override
    public Iterable<ConfluenceUser> getMembers(Group group, int limit) {
        if (group == null) {
            return Collections.emptyList();
        }
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be greater than or equal to 0");
        }
        try {
            Pager groupMembers = this.getGroupManager().getMemberNames(group);
            if (groupMembers == null) {
                return Collections.emptyList();
            }
            if (limit == 0) {
                return StreamSupport.stream(groupMembers.spliterator(), false).map(this::getUserByName).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return StreamSupport.stream(groupMembers.spliterator(), false).limit(limit).map(this::getUserByName).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (EntityException e) {
            log.error("Group {} limit {} exception message {} exception {}", new Object[]{group, limit, e.getMessage(), e});
            return Collections.emptyList();
        }
    }

    @Override
    public List<Group> getWriteableGroups() {
        return this.getGroupManager().getWritableGroups();
    }

    @Override
    @Deprecated(forRemoval=true)
    @Transactional(readOnly=true)
    public PropertySet getPropertySet(ConfluenceUser user) {
        return this.userPreferencesAccessor.getPropertySet(user);
    }

    @Override
    public List<com.atlassian.user.User> findUsersAsList(Query<com.atlassian.user.User> search) throws EntityException {
        return this.atlassianUserQueryHelper.findUsersAsList(search);
    }

    public SearchResult<com.atlassian.user.User> findUsers(Query<com.atlassian.user.User> query) throws EntityException {
        return this.atlassianUserQueryHelper.findUsers(query);
    }

    @Override
    public ConfluenceUser renameUser(ConfluenceUser user, String newUsername) throws EntityException {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        if (this.crowdService.getUser(newUsername) != null) {
            throw new DuplicateEntityException("User with username '" + newUsername + "' already exists.");
        }
        try {
            this.crowdService.renameUser(this.toCrowdUser(user), newUsername);
            return user.getName().equals(newUsername) ? user : this.getUserByKey(user.getKey());
        }
        catch (InvalidUserException e) {
            throw new EntityValidationException((Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
    }

    @Override
    public List<Group> getGroupsByGroupNames(List<String> groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<Group> groups = new ArrayList<Group>();
            List partitions = Lists.partition(groupNames, (int)this.bulkFetchGroupBatchSize);
            for (List partition : partitions) {
                groups.addAll(this.atlassianUserQueryHelper.findGroupsByName(partition));
            }
            return groups;
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public @NonNull PageResponse<ConfluenceUser> getUsers(LimitedRequest limitedRequest) {
        return this.userResolver.getUsers(limitedRequest);
    }

    @Override
    public @NonNull List<ConfluenceUser> getUsersByUserKeys(List<UserKey> userKeys) {
        return this.userResolver.getUsersByUserKeys(userKeys);
    }

    @Override
    public @Nullable ConfluenceUser getExistingUserByPerson(@NonNull Person person) {
        return this.userResolver.getExistingUserByPerson(person);
    }

    @Override
    public @NonNull Optional<ConfluenceUser> getExistingByApiUser(com.atlassian.confluence.api.model.people.User user) {
        return this.userResolver.getExistingByApiUser(user);
    }

    @Override
    public int countUnsyncedUsers() {
        return this.confluenceUserDao.countUnsyncedUsers();
    }

    @Override
    public SearchResult<com.atlassian.user.User> getUsersByEmail(String email) {
        return this.atlassianUserQueryHelper.getUsersByEmail(email);
    }

    @Override
    public void alterPassword(com.atlassian.user.User user, String plainTextPassword, String token) throws EntityException {
        if (!this.isValidAlterPasswordToken(user, token)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername(), "Unable to change user password without valid token.");
        }
        this.getUserManager().alterPassword(user, plainTextPassword);
    }

    @Override
    public void alterPassword(com.atlassian.user.User user, String plainTextPassword) throws EntityException {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.getUserManager().alterPassword(user, plainTextPassword);
    }

    private void fireUserEvent(Object event) {
        if (this.bootstrapManager.isSetupComplete()) {
            this.eventPublisher.publish(event);
        }
    }

    private void userWillBeCreated() {
        if (!this.isLicensedToAddMoreUsers()) {
            throw new LicenseUserLimitExceededException("You are not licensed to add any more users to this installation of Confluence. Please contact sales@atlassian.com");
        }
    }

    private void userWasCreated(com.atlassian.user.User user) {
        this.personalInformationManager.createPersonalInformation(user);
        this.userChecker.incrementRegisteredUserCount();
        this.fireUserEvent(new UserCreateEvent(this, user));
    }

    private static String normalise(String name) {
        return name.toLowerCase(Locale.ENGLISH);
    }

    private User toCrowdUser(com.atlassian.user.User legacyUser) {
        return new CrowdUserConversionHelper(this.crowdService).toCrowdUser(legacyUser);
    }

    private boolean isValidAlterPasswordToken(com.atlassian.user.User user, String token) {
        String username = user.getName();
        return this.userVerificationTokenManager.hasValidUserToken(username, UserVerificationTokenType.PASSWORD_RESET, token) || this.userVerificationTokenManager.hasValidUserToken(username, UserVerificationTokenType.USER_SIGNUP, token);
    }

    @Override
    public void deactivateUserLocally(com.atlassian.user.User user) throws EntityValidationException, UserManagementOperationFailedException {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.SET_PERMISSIONS, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            this.disabledUserManager.disableEnableUserLocally(this.toCrowdUser(user), false);
            this.userChecker.decrementRegisteredUserCount();
            this.eventPublisher.publish((Object)new UserDeactivateEvent(this, user, true));
        }
        catch (UserManagementOperationFailedException | EntityValidationException e) {
            log.error("Attempt to deactivate user {} unsuccessful: {}", (Object)user.getName(), (Object)((Throwable)e).getMessage());
            throw e;
        }
    }

    @Override
    public Pager<String> getUserNames() {
        Pager pager = null;
        try {
            pager = this.getUserManager().getUserNames();
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return pager;
    }

    @Override
    public Pager<com.atlassian.user.User> getUsers() {
        Pager pager = null;
        try {
            pager = this.getUserManager().getUsers();
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return pager;
    }

    @Override
    @Deprecated
    public @Nullable com.atlassian.user.User getUser(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        com.atlassian.user.User user = null;
        try {
            user = this.getUserManager().getUser(name);
        }
        catch (EntityException e) {
            try {
                user = this.getUserManager().getUser(name.toLowerCase());
            }
            catch (EntityException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
        }
        return user;
    }

    @Override
    public Pager<Group> getGroups() {
        Pager pager = null;
        try {
            pager = this.getGroupManager().getGroups();
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return pager;
    }

    public SearchResult<Group> findGroups(Query<Group> query) throws EntityException {
        return this.getEntityQueryParser().findGroups(query);
    }

    public SearchResult<com.atlassian.user.User> findUsers(Query<com.atlassian.user.User> query, QueryContext context) throws EntityException {
        return this.getEntityQueryParser().findUsers(query);
    }

    public SearchResult<Group> findGroups(Query<Group> query, QueryContext context) throws EntityException {
        return this.getEntityQueryParser().findGroups(query);
    }

    @Override
    public Pager<Group> getGroups(com.atlassian.user.User user) {
        if (user == null) {
            return DefaultPager.emptyPager();
        }
        try {
            return this.getGroupManager().getGroups(user);
        }
        catch (EntityException e) {
            log.error("Failed to retrieve groups for user [{}]", (Object)user.getName(), (Object)e);
        }
        catch (ConcurrentModificationException e) {
            log.error("Failed to retrieve groups for user [{}]", (Object)user.getName(), (Object)e);
        }
        return DefaultPager.emptyPager();
    }

    @Override
    public boolean hasMembership(Group group, com.atlassian.user.User user) {
        if (group == null || user == null) {
            return false;
        }
        boolean result = false;
        try {
            result = this.getGroupManager().hasMembership(group, user);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean hasMembership(String groupName, String username) {
        if (StringUtils.isEmpty((CharSequence)groupName) || StringUtils.isEmpty((CharSequence)username)) {
            return false;
        }
        try {
            Group group = this.getGroupManager().getGroup(groupName);
            if (group == null) {
                return false;
            }
            com.atlassian.user.User user = this.getUserManager().getUser(username);
            if (user == null) {
                return false;
            }
            return this.hasMembership(group, user);
        }
        catch (EntityException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean authenticate(String username, String password) {
        boolean result = false;
        try {
            result = this.getAuthenticator().authenticate(username, password);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected UserManager getUserManager() {
        return this.repositoryAccessor.getUserManager();
    }

    protected GroupManager getGroupManager() {
        return this.repositoryAccessor.getGroupManager();
    }

    protected Authenticator getAuthenticator() {
        return this.repositoryAccessor.getAuthenticator();
    }

    protected EntityQueryParser getEntityQueryParser() {
        return this.repositoryAccessor.getEntityQueryParser();
    }
}

