/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user;

import com.atlassian.confluence.impl.user.UserPreferencesAccessorInternal;
import com.atlassian.confluence.impl.user.preferences.UserPreferencesFactory;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreferencesDao;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPreferencesAccessorImpl
implements UserPreferencesAccessorInternal {
    private static final Logger log = LoggerFactory.getLogger(UserPreferencesAccessorImpl.class);
    private final PropertySetFactory propertySetFactory;
    private final UserPreferencesFactory userPreferencesFactory;
    private final UserPreferencesDao userPreferencesDao;

    public UserPreferencesAccessorImpl(PropertySetFactory propertySetFactory, UserPreferencesFactory userPreferencesFactory, UserPreferencesDao userPreferencesDao) {
        this.propertySetFactory = Objects.requireNonNull(propertySetFactory);
        this.userPreferencesFactory = Objects.requireNonNull(userPreferencesFactory);
        this.userPreferencesDao = Objects.requireNonNull(userPreferencesDao);
    }

    @Override
    public @NonNull UserPreferences getUserPreferences(@Nullable ConfluenceUser user) {
        return this.userPreferencesFactory.getUserPreferences(user != null ? user.getKey() : null);
    }

    @Override
    @Deprecated(forRemoval=true, since="9.3")
    public @Nullable PropertySet getPropertySet(@Nullable User user) {
        if (user == null) {
            return null;
        }
        PropertySet ps = null;
        try {
            ps = this.propertySetFactory.getPropertySet((Entity)user);
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return ps;
    }

    @Override
    public void removeAllUserPreferences(@NonNull ConfluenceUser user) {
        this.userPreferencesDao.removeAllUserPreferences(user.getKey());
    }
}

