/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user;

import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.core.SynchronizationManager;
import com.atlassian.confluence.event.events.user.UserRemoveCompletedEvent;
import com.atlassian.confluence.event.events.user.UserRemoveEvent;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.impl.user.UserMentionsContentReindexer;
import com.atlassian.confluence.impl.user.UserPreferencesAccessorInternal;
import com.atlassian.confluence.internal.security.SpacePermissionContext;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserManagementOperationFailedException;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.search.page.DefaultPager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserRemover {
    private static final Logger log = LoggerFactory.getLogger(UserRemover.class);
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final UserPreferencesAccessorInternal userPreferencesAccessor;
    private final PersonalInformationManager personalInformationManager;
    private final SpacePermissionManagerInternal spacePermissionManager;
    private final NotificationManager notificationManager;
    private final FollowManager followManager;
    private final EventPublisher eventPublisher;
    private final ConfluenceUserDao confluenceUserDao;
    private final UserMentionsContentReindexer userMentionsContentReindexer;
    private final UserChecker userChecker;
    private final SynchronizationManager synchronizationManager;
    private final DisabledUserManager disabledUserManager;
    private final ConfluenceUserResolver userResolver;

    UserRemover(RepositoryAccessor repositoryAccessor, PermissionManager permissionManager, UserPreferencesAccessorInternal userPreferencesAccessor, PersonalInformationManager personalInformationManager, SpacePermissionManagerInternal spacePermissionManager, NotificationManager notificationManager, FollowManager followManager, EventPublisher eventPublisher, ConfluenceUserDao confluenceUserDao, UserMentionsContentReindexer userMentionsContentReindexer, UserChecker userChecker, SynchronizationManager synchronizationManager, DisabledUserManager disabledUserManager, ConfluenceUserResolver userResolver) {
        this.groupManager = repositoryAccessor.getGroupManager();
        this.userManager = repositoryAccessor.getUserManager();
        this.permissionManager = permissionManager;
        this.userPreferencesAccessor = userPreferencesAccessor;
        this.personalInformationManager = personalInformationManager;
        this.spacePermissionManager = spacePermissionManager;
        this.notificationManager = notificationManager;
        this.followManager = followManager;
        this.eventPublisher = eventPublisher;
        this.confluenceUserDao = confluenceUserDao;
        this.userMentionsContentReindexer = userMentionsContentReindexer;
        this.userChecker = userChecker;
        this.synchronizationManager = synchronizationManager;
        this.disabledUserManager = disabledUserManager;
        this.userResolver = userResolver;
    }

    private boolean isCrowdManaged(ConfluenceUser user) {
        return !this.confluenceUserDao.isUnsyncedUser(user) && !this.confluenceUserDao.isDeletedUser(user);
    }

    public void removeUser(User user) {
        long startRemove = System.currentTimeMillis();
        if (user == null) {
            throw new IllegalArgumentException("Do not call delete with a null user");
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.REMOVE, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        ConfluenceUser confluenceUser = FindUserHelper.getUser(user);
        if (confluenceUser == null) {
            return;
        }
        boolean isCrowdManaged = this.isCrowdManaged(confluenceUser);
        if (isCrowdManaged) {
            DefaultPager groups = DefaultPager.emptyPager();
            try {
                groups = this.groupManager.getGroups((User)confluenceUser);
            }
            catch (EntityException e) {
                log.error("Error retrieving groups during user removal", (Throwable)e);
            }
            groups.forEach(group -> {
                log.info("Removing user with key [{}] from group {}", (Object)confluenceUser.getKey().getStringValue(), (Object)group.getName());
                try {
                    this.groupManager.removeMembership(group, (User)confluenceUser);
                }
                catch (Exception e) {
                    log.error("Failed to remove '{}' as a member of '{}'", new Object[]{user.getName(), group.getName(), e});
                }
                finally {
                    this.userChecker.resetResult();
                }
            });
        }
        this.userPreferencesAccessor.removeAllUserPreferences(confluenceUser);
        this.personalInformationManager.removePersonalInformation(confluenceUser);
        this.spacePermissionManager.removeAllUserPermissions(confluenceUser, SpacePermissionContext.createDefault());
        this.notificationManager.removeAllNotificationsForUser(confluenceUser);
        this.followManager.removeAllConnectionsFor(confluenceUser);
        this.eventPublisher.publish((Object)new UserRemoveEvent(this, confluenceUser));
        try {
            ConfluenceUser userToRemove;
            if (isCrowdManaged && (userToRemove = this.userResolver.getUserByName(confluenceUser.getName())) != null) {
                try {
                    this.userManager.removeUser((User)userToRemove);
                }
                catch (EntityException e) {
                    throw new InfrastructureException((Throwable)e);
                }
            }
            String username = confluenceUser.getName();
            this.confluenceUserDao.rename(confluenceUser, confluenceUser.getKey().getStringValue(), true);
            this.userMentionsContentReindexer.reindex(confluenceUser, username);
            if (isCrowdManaged && !this.disabledUserManager.isDisabled(confluenceUser)) {
                this.userChecker.decrementRegisteredUserCount();
            }
        }
        catch (CrowdRuntimeException e) {
            throw new UserManagementOperationFailedException(e);
        }
        this.synchronizationManager.runOnSuccessfulCommit(() -> this.eventPublisher.publish((Object)new UserRemoveCompletedEvent(this, confluenceUser)));
        log.info("Finished removing user with key [{}] in {}ms", (Object)confluenceUser.getKey().getStringValue(), (Object)(System.currentTimeMillis() - startRemove));
    }
}

