/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.user.Group;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CrowdDirectoryEntityHelper {
    private static final Logger log = LoggerFactory.getLogger(CrowdDirectoryEntityHelper.class);
    private final DirectoryManager crowdDirectoryManager;
    private final CrowdDirectoryService crowdDirectoryService;
    private final ApplicationService crowdApplicationService;
    private final ApplicationDAO applicationDAO;

    public CrowdDirectoryEntityHelper(CrowdDirectoryService crowdDirectoryService, DirectoryManager crowdDirectoryManager, ApplicationService crowdApplicationService, ApplicationDAO applicationDAO) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdDirectoryManager = crowdDirectoryManager;
        this.crowdApplicationService = crowdApplicationService;
        this.applicationDAO = applicationDAO;
    }

    private List<Directory> getActiveDirectories() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(Directory::isActive).toList();
    }

    private EntityQuery<String> allUserQuery(boolean isActive) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)).returningAtMost(-1);
    }

    public <T extends DirectoryEntity> boolean isCanonical(@Nullable T entity) {
        Optional<DirectoryEntity> canonicalEntity;
        if (entity == null) {
            return true;
        }
        Directory firstActive = (Directory)Iterables.getFirst(this.getActiveDirectories(), null);
        if (firstActive == null) {
            return false;
        }
        if (firstActive.getId().equals(entity.getDirectoryId())) {
            return true;
        }
        if (entity instanceof User) {
            canonicalEntity = this.findByName(entity.getName().toLowerCase(), User.class);
        } else if (entity instanceof com.atlassian.crowd.model.group.Group) {
            canonicalEntity = this.findByName(entity.getName().toLowerCase(), com.atlassian.crowd.model.group.Group.class);
        } else {
            throw new IllegalArgumentException("Entity must be an instance of User or Group (was " + entity.getClass().getName() + ")");
        }
        return canonicalEntity.isPresent() && entity.getDirectoryId() == canonicalEntity.get().getDirectoryId();
    }

    public boolean wasCanonical(String oldUsername, User userWithNewUsername) {
        Optional<DirectoryEntity> userWithOldUsername = this.findByName(oldUsername, User.class);
        return userWithOldUsername.isEmpty() || this.isInHigherOrEqualDirectory(userWithNewUsername, (User)userWithOldUsername.get());
    }

    private boolean isInHigherOrEqualDirectory(User user1, User user2) {
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (directory.getId().longValue() == user1.getDirectoryId()) {
                return true;
            }
            if (directory.getId().longValue() != user2.getDirectoryId()) continue;
            return false;
        }
        return false;
    }

    public Optional<DirectoryEntity> findByName(String name, Class<? extends DirectoryEntity> entityClass) {
        User entity;
        block4: {
            try {
                Application application = this.applicationDAO.findByName("crowd-embedded");
                String lowercaseName = name.toLowerCase();
                if (entityClass.equals(User.class)) {
                    entity = this.crowdApplicationService.findUserByName(application, lowercaseName);
                    break block4;
                }
                if (entityClass.equals(com.atlassian.crowd.model.group.Group.class)) {
                    entity = this.crowdApplicationService.findGroupByName(application, lowercaseName);
                    break block4;
                }
                throw new IllegalArgumentException("Entity must be an instance of User or Group (was " + name + ")");
            }
            catch (ApplicationNotFoundException | GroupNotFoundException | UserNotFoundException e) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(entity);
    }

    public List<String> getActiveUserNames() {
        EntityQuery<String> activeUserQuery = this.allUserQuery(true);
        EntityQuery<String> inactiveUserQuery = this.allUserQuery(false);
        HashMap globalDirectoryActiveUsersByLowerName = new HashMap();
        HashSet globalDirectoryInActiveUsers = new HashSet();
        try {
            List<Directory> directories = this.getActiveDirectories();
            for (Directory directory : directories) {
                Long directoryId = directory.getId();
                Map<String, String> currentDirectoryActiveUsersByLowerName = this.crowdDirectoryManager.searchUsers(directoryId.longValue(), activeUserQuery).stream().collect(Collectors.toMap(IdentifierUtils::toLowerCase, user -> user));
                currentDirectoryActiveUsersByLowerName.keySet().removeAll(globalDirectoryInActiveUsers);
                globalDirectoryInActiveUsers.addAll(this.crowdDirectoryManager.searchUsers(directoryId.longValue(), inactiveUserQuery).stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet()));
                currentDirectoryActiveUsersByLowerName.forEach(globalDirectoryActiveUsersByLowerName::putIfAbsent);
            }
        }
        catch (DirectoryNotFoundException e) {
            log.error("Directory name '{}' doesn't exist '{}'", (Object)e.getDirectoryName(), (Object)e);
        }
        catch (OperationFailedException e) {
            log.error("Operation failed '{}'", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Failed to get the active users from directories", (Throwable)e);
        }
        return globalDirectoryActiveUsersByLowerName.values().stream().toList();
    }

    public User addUser(UserTemplateWithAttributes userTemplate, String credential) throws DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, InvalidCredentialException, UserAlreadyExistsException, InvalidUserException {
        return this.crowdDirectoryManager.addUser(userTemplate.getDirectoryId(), userTemplate, new PasswordCredential(credential));
    }

    public Optional<User> findUserByName(long directoryId, String username) {
        try {
            return Optional.of(this.crowdDirectoryManager.findUserByName(directoryId, username));
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            log.warn("Could not find user in directory with ID [{}], caused by [{}]", (Object)directoryId, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<com.atlassian.crowd.model.group.Group> findGroupByName(long directoryId, String groupName) {
        try {
            return Optional.of(this.crowdDirectoryManager.findGroupByName(directoryId, groupName));
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            log.warn("Could not find group in directory with ID [{}], caused by [{}]", (Object)directoryId, (Object)e);
            return Optional.empty();
        }
    }

    public boolean userExistsInAnyDirectories(String username, String parentGroupName) {
        return this.getActiveDirectories().stream().anyMatch(directory -> {
            try {
                return this.crowdDirectoryManager.isUserDirectGroupMember(directory.getId().longValue(), username, parentGroupName);
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.warn("Could not check user membership in directory with ID [{}] while checking if user exists in any directories", (Object)directory.getId());
                return false;
            }
        });
    }

    public boolean groupExistsInAnyDirectories(String childGroupName, String parentGroupName) {
        return this.getActiveDirectories().stream().anyMatch(directory -> {
            try {
                return this.crowdDirectoryManager.isGroupDirectGroupMember(directory.getId().longValue(), childGroupName, parentGroupName);
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.warn("Could not check group membership in directory with ID [{}] while checking if group exists in any directories", (Object)directory.getId());
                return false;
            }
        });
    }

    public boolean userExistsInAnyDirectoriesBesidesDirectory(String username, String groupName, String excludedDirectoryName) {
        return this.getActiveDirectories().stream().filter(directory -> !directory.getName().equals(excludedDirectoryName)).anyMatch(directory -> {
            try {
                return this.crowdDirectoryManager.isUserDirectGroupMember(directory.getId().longValue(), username, groupName);
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.warn("Could not check user membership in directory with ID [{}] while checking if user exists in any directories besides one", (Object)directory.getId());
                return false;
            }
        });
    }

    public boolean groupExistsInAnyDirectoriesBesidesDirectory(String childGroupName, String parentGroupName, String excludedDirectoryName) {
        return this.getActiveDirectories().stream().filter(directory -> !directory.getName().equals(excludedDirectoryName)).anyMatch(directory -> {
            try {
                return this.crowdDirectoryManager.isGroupDirectGroupMember(directory.getId().longValue(), childGroupName, parentGroupName);
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.warn("Could not check group membership in directory with ID [{}] while checking if group exists in any directories besides one", (Object)directory.getId());
                return false;
            }
        });
    }

    public List<com.atlassian.crowd.model.group.Group> getDirectParent(Group group) throws ApplicationNotFoundException {
        Application application = this.applicationDAO.findByName("crowd-embedded");
        return this.crowdApplicationService.searchDirectGroupRelationships(application, Queries.groupParent(group));
    }

    @VisibleForTesting
    static class Queries {
        Queries() {
        }

        protected static MembershipQuery<com.atlassian.crowd.model.group.Group> groupParent(Group group) {
            return QueryBuilder.queryFor(com.atlassian.crowd.model.group.Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1);
        }
    }
}

