/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd;

import com.atlassian.crowd.crypto.Algorithm;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionSettingsImpl
implements EncryptionSettings {
    public static final String KEYS_SUB_DIRECTORY = File.separator + "keys";
    private static final Logger log = LoggerFactory.getLogger(EncryptionSettingsImpl.class);
    private final ApplicationProperties applicationProperties;
    private final PluginSettings globalSettings;

    public EncryptionSettingsImpl(ApplicationProperties applicationProperties, PluginSettingsFactory pluginSettingsFactory) {
        this.applicationProperties = applicationProperties;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public Optional<String> getDefaultEncryptor() {
        return Optional.of(Algorithm.AES.getKey());
    }

    public void setDefaultEncryptor(String encryptor) {
        log.warn("AES encryption is the only supported standard, cannot change default encryption.");
    }

    public void setEncryptionKeyPath(String encryptor, String keyPath) {
        this.globalSettings.put(this.getPropertyNameForEncryptionKeyPath(encryptor), (Object)keyPath);
    }

    public Optional<String> getEncryptionKeyPath(String encryptor) {
        Object object = this.globalSettings.get(this.getPropertyNameForEncryptionKeyPath(encryptor));
        if (object instanceof String) {
            String encryptorKeyPath = (String)object;
            return Optional.of(encryptorKeyPath);
        }
        return Optional.empty();
    }

    public String getKeyFilesDirectoryPath() {
        String keyFilesDirectoryPath;
        Optional sharedHome = this.applicationProperties.getSharedHomeDirectory();
        Optional localHome = this.applicationProperties.getLocalHomeDirectory();
        if (sharedHome.isPresent()) {
            keyFilesDirectoryPath = String.valueOf(sharedHome.get()) + KEYS_SUB_DIRECTORY;
        } else if (localHome.isPresent()) {
            keyFilesDirectoryPath = String.valueOf(localHome.get()) + KEYS_SUB_DIRECTORY;
        } else {
            throw new EncryptionException("Local home path is not configured");
        }
        this.validateKeysDirectory(new File(keyFilesDirectoryPath));
        return keyFilesDirectoryPath;
    }

    private String getPropertyNameForEncryptionKeyPath(String encryptor) {
        return String.format("crowd.encryption.encryptor.%s.keyPath", encryptor);
    }

    private void validateKeysDirectory(File keyFilesDirectoryPath) {
        if (!keyFilesDirectoryPath.exists() && !keyFilesDirectoryPath.mkdirs()) {
            String message = "Encryption keys directory cannot be created in your home directory. Check the filesystem permissions.";
            log.error(message);
            throw new EncryptionException(message);
        }
        if (!(keyFilesDirectoryPath.isDirectory() && keyFilesDirectoryPath.canRead() && keyFilesDirectoryPath.canWrite())) {
            String message = "Encryption keys directory cannot be accessed in your home directory. Check the filesystem permissions.";
            log.error(message);
            throw new EncryptionException(message);
        }
    }

    static class EncryptionException
    extends RuntimeException {
        public EncryptionException(String message) {
            super(message);
        }
    }
}

