/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.hibernate;

import com.atlassian.confluence.impl.user.crowd.hibernate.HibernateSearch;
import com.atlassian.confluence.impl.user.crowd.hibernate.InternalGroupDao;
import com.atlassian.confluence.impl.user.crowd.hibernate.InternalMembershipDao;
import com.atlassian.confluence.impl.user.crowd.hibernate.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class HibernateDirectoryDao
implements DirectoryDao {
    private final SessionFactory sessionFactory;
    private final InternalUserDao<?> userDao;
    private final InternalGroupDao<?> groupDao;
    private final InternalMembershipDao internalMembershipDao;

    public HibernateDirectoryDao(SessionFactory sessionFactory, InternalUserDao<?> userDao, InternalGroupDao<?> groupDao, InternalMembershipDao internalMembershipDao) {
        this.sessionFactory = sessionFactory;
        this.userDao = userDao;
        this.groupDao = groupDao;
        this.internalMembershipDao = internalMembershipDao;
    }

    @Transactional(readOnly=true)
    public DirectoryImpl findById(long directoryId) throws DirectoryNotFoundException {
        DirectoryImpl directory = (DirectoryImpl)this.sessionFactory.getCurrentSession().get(DirectoryImpl.class, (Serializable)Long.valueOf(directoryId));
        if (directory == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        return directory;
    }

    @Transactional(readOnly=true)
    public Directory findByName(String name) throws DirectoryNotFoundException {
        CriteriaBuilder builder = this.sessionFactory.getCurrentSession().getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DirectoryImpl.class);
        Root directory = query.from(DirectoryImpl.class);
        query.where((Expression)builder.equal((Expression)directory.get("lowerName"), (Object)IdentifierUtils.toLowerCase((String)name)));
        return (Directory)this.sessionFactory.getCurrentSession().createQuery(query).uniqueResultOptional().orElseThrow(() -> new DirectoryNotFoundException(name));
    }

    @Transactional(readOnly=true)
    public List<Directory> findAll() {
        Query query = this.sessionFactory.getCurrentSession().createQuery("from DirectoryImpl", Directory.class);
        query.setCacheable(true);
        return query.list();
    }

    public Directory add(Directory directory) {
        DirectoryImpl directoryToPersist = new DirectoryImpl(directory);
        directoryToPersist.setCreatedDateToNow();
        directoryToPersist.setUpdatedDateToNow();
        directoryToPersist.validate();
        this.sessionFactory.getCurrentSession().save((Object)directoryToPersist);
        return directoryToPersist;
    }

    public Directory update(Directory directory) throws DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = this.findById(directory.getId());
        directoryToUpdate.setUpdatedDateToNow();
        directoryToUpdate.updateDetailsFrom(directory);
        directoryToUpdate.validate();
        directoryToUpdate.getAttributes().entrySet().removeIf(attr -> attr.getValue() == null || ((String)attr.getValue()).isEmpty());
        this.sessionFactory.getCurrentSession().update((Object)directoryToUpdate);
        return directoryToUpdate;
    }

    public void remove(Directory directory) throws DirectoryNotFoundException {
        DirectoryImpl directoryToRemove = this.findById(directory.getId());
        this.internalMembershipDao.removeAllRelationships((Directory)directoryToRemove);
        this.groupDao.removeAllGroups(directoryToRemove.getId());
        this.userDao.removeAllUsers(directoryToRemove.getId());
        this.sessionFactory.getCurrentSession().delete((Object)directoryToRemove);
        this.sessionFactory.getCurrentSession().flush();
    }

    @Transactional(readOnly=true)
    public List<Directory> search(EntityQuery<Directory> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.DIRECTORY) {
            throw new IllegalArgumentException("DirectoryDAO can only evaluate EntityQueries for Entity.DIRECTORY");
        }
        return HibernateSearch.forEntities(query).doInHibernate(this.sessionFactory.getCurrentSession());
    }
}

