/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.hibernate;

import com.atlassian.crowd.directory.DirectorySynchronisationStatusImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectorySynchronisationStatusDao;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.directory.DirectorySynchronisationStatus;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class HibernateDirectorySynchronisationStatusDao
implements DirectorySynchronisationStatusDao {
    private final SessionFactory sessionFactory;
    private final TransactionTemplate transactionTemplate;

    public HibernateDirectorySynchronisationStatusDao(SessionFactory sessionFactory, TransactionTemplate transactionTemplate) {
        this.sessionFactory = sessionFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @Transactional(readOnly=true)
    public Optional<DirectorySynchronisationStatus> findActiveForDirectory(long directoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DirectorySynchronisationStatusImpl.class);
        Root status = query.from(DirectorySynchronisationStatusImpl.class);
        query.where((Expression)builder.and((Expression)builder.equal((Expression)status.get("directory").get("id"), (Object)directoryId), (Expression)builder.isNull((Expression)status.get("endTimestamp"))));
        query.orderBy(new Order[]{builder.desc((Expression)status.get("startTimestamp"))});
        DirectorySynchronisationStatusImpl result = (DirectorySynchronisationStatusImpl)session.createQuery(query).setMaxResults(1).uniqueResult();
        return Optional.ofNullable(result);
    }

    @Transactional(readOnly=true)
    public Optional<DirectorySynchronisationStatus> findLastForDirectory(long directoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DirectorySynchronisationStatusImpl.class);
        Subquery subquery = query.subquery(Long.class);
        Root subStatus = subquery.from(DirectorySynchronisationStatusImpl.class);
        subquery.select(builder.max((Expression)subStatus.get("endTimestamp")));
        subquery.where((Expression)builder.equal((Expression)subStatus.get("directory").get("id"), (Object)directoryId));
        Root status = query.from(DirectorySynchronisationStatusImpl.class);
        query.where((Expression)builder.and((Expression)builder.equal((Expression)status.get("directory").get("id"), (Object)directoryId), (Expression)builder.equal((Expression)status.get("endTimestamp"), (Expression)subquery)));
        return Optional.ofNullable((DirectorySynchronisationStatus)session.createQuery(query).uniqueResult());
    }

    public DirectorySynchronisationStatus add(DirectorySynchronisationStatus status) {
        Preconditions.checkArgument((status.getId() == null ? 1 : 0) != 0, (Object)"Tried to create DirectorySynchronisationStatus with id specified");
        Session session = this.sessionFactory.getCurrentSession();
        Directory directory = (Directory)session.get(DirectoryImpl.class, (Serializable)status.getDirectory().getId());
        DirectorySynchronisationStatusImpl newStatus = DirectorySynchronisationStatusImpl.builder((DirectorySynchronisationStatus)status, serializables -> null).setDirectory(directory).build();
        session.save((Object)newStatus);
        return newStatus;
    }

    public DirectorySynchronisationStatus update(DirectorySynchronisationStatus status) {
        Session session = this.sessionFactory.getCurrentSession();
        DirectorySynchronisationStatusImpl impl = (DirectorySynchronisationStatusImpl)session.find(DirectorySynchronisationStatusImpl.class, (Object)status.getId());
        if (impl == null) {
            return null;
        }
        impl.setStartTimestamp(status.getStartTimestamp());
        impl.setEndTimestamp(status.getEndTimestamp());
        impl.setStatus(status.getStatus());
        impl.setStatusParameters(status.getStatusParameters());
        impl.setNodeId(status.getNodeId());
        impl.setNodeName(status.getNodeName());
        impl.setIncrementalSyncError(status.getIncrementalSyncError());
        impl.setFullSyncError(status.getFullSyncError());
        session.update((Object)impl);
        return impl;
    }

    public long removeStatusesForDirectory(Long directoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaDelete delete = builder.createCriteriaDelete(DirectorySynchronisationStatusImpl.class);
        Root status = delete.from(DirectorySynchronisationStatusImpl.class);
        delete.where((Expression)builder.equal((Expression)status.get("directory").get("id"), (Object)directoryId));
        return session.createQuery(delete).executeUpdate();
    }

    public long removeAll() {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaDelete delete = builder.createCriteriaDelete(DirectorySynchronisationStatusImpl.class);
        delete.from(DirectorySynchronisationStatusImpl.class);
        return session.createQuery(delete).executeUpdate();
    }

    public long removeAllExcept(long directoryId, int statusId) {
        return ((Integer)this.transactionTemplate.execute(() -> {
            Session session = this.sessionFactory.getCurrentSession();
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaDelete delete = builder.createCriteriaDelete(DirectorySynchronisationStatusImpl.class);
            Root status = delete.from(DirectorySynchronisationStatusImpl.class);
            delete.where((Expression)builder.and((Expression)builder.equal((Expression)status.get("directory").get("id"), (Object)directoryId), (Expression)builder.notEqual((Expression)status.get("id"), (Object)statusId)));
            return session.createQuery(delete).executeUpdate();
        })).intValue();
    }

    @Transactional(readOnly=true)
    public Collection<DirectorySynchronisationStatus> findActiveSyncsWhereNodeIdNotIn(Set<String> nodesIds) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DirectorySynchronisationStatusImpl.class);
        Root status = query.from(DirectorySynchronisationStatusImpl.class);
        query.where((Expression)builder.and((Expression)builder.not((Expression)status.get("nodeId").in(nodesIds)), (Expression)builder.isNull((Expression)status.get("endTimestamp"))));
        List result = session.createQuery(query).getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }
}

