/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.hibernate;

import com.atlassian.crowd.directory.DirectorySynchronisationToken;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.DirectorySynchronisationTokenDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class HibernateDirectorySynchronisationTokenDao
implements DirectorySynchronisationTokenDao {
    private final SessionFactory sessionFactory;
    private final TransactionTemplate transactionTemplate;
    private final DirectoryDao directoryDao;

    public HibernateDirectorySynchronisationTokenDao(SessionFactory sessionFactory, TransactionTemplate transactionTemplate, DirectoryDao directoryDao) {
        this.sessionFactory = sessionFactory;
        this.transactionTemplate = transactionTemplate;
        this.directoryDao = directoryDao;
    }

    @Transactional(readOnly=true)
    public @Nullable String getLastSynchronisationTokenForDirectory(long directoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(String.class);
        Root token = query.from(DirectorySynchronisationToken.class);
        query.select((Selection)token.get("synchronisationToken"));
        query.where((Expression)builder.equal((Expression)token.get("directoryId"), (Object)directoryId));
        try (Stream stream = session.createQuery(query).stream();){
            String string = stream.filter(Objects::nonNull).findFirst().orElse(null);
            return string;
        }
    }

    public void storeSynchronisationTokenForDirectory(long directoryId, String synchronisationToken) throws DirectoryNotFoundException {
        Directory directory = this.directoryDao.findById(directoryId);
        this.transactionTemplate.execute(() -> {
            Session session = this.sessionFactory.getCurrentSession();
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(DirectorySynchronisationToken.class);
            Root tokenRoot = query.from(DirectorySynchronisationToken.class);
            query.where((Expression)builder.equal((Expression)tokenRoot.get("directoryId"), (Object)directoryId));
            DirectorySynchronisationToken token = (DirectorySynchronisationToken)DataAccessUtils.singleResult((Collection)session.createQuery(query).getResultList());
            if (token == null) {
                token = new DirectorySynchronisationToken(directory, synchronisationToken);
            } else {
                token.setSynchronisationToken(synchronisationToken);
            }
            session.saveOrUpdate((Object)token);
            return null;
        });
    }

    public void clearSynchronisationTokenForDirectory(long directoryId) {
        this.transactionTemplate.execute(() -> {
            Session session = this.sessionFactory.getCurrentSession();
            Optional.ofNullable((DirectorySynchronisationToken)session.get(DirectorySynchronisationToken.class, (Serializable)Long.valueOf(directoryId))).ifPresent(arg_0 -> ((Session)session).remove(arg_0));
            return directoryId;
        });
    }
}

