/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.hibernate;

import com.atlassian.confluence.impl.user.crowd.hibernate.HibernateSearch;
import com.atlassian.confluence.impl.user.crowd.hibernate.InternalGroupDao;
import com.atlassian.confluence.impl.user.crowd.hibernate.InternalMembershipDao;
import com.atlassian.confluence.impl.user.crowd.hibernate.batch.operation.SaveOrUpdateOperation;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchFinder;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateGroupDao
implements InternalGroupDao<InternalGroup> {
    private static final Logger log = LoggerFactory.getLogger(HibernateGroupDao.class);
    private final SessionFactory sessionFactory;
    private final Supplier<DirectoryDao> directoryDao;
    private final InternalMembershipDao membershipDao;
    private final BatchProcessor<Session> batchProcessor;
    private final BatchFinder batchFinder;

    public HibernateGroupDao(SessionFactory sessionFactory, Supplier<DirectoryDao> directoryDao, InternalMembershipDao membershipDao, BatchProcessor<Session> batchProcessor, BatchFinder batchFinder) {
        this.sessionFactory = sessionFactory;
        this.directoryDao = directoryDao;
        this.membershipDao = membershipDao;
        this.batchProcessor = batchProcessor;
        this.batchFinder = batchFinder;
    }

    public InternalDirectoryGroup findByName(long directoryId, String name) throws GroupNotFoundException {
        return this.internalFindByName(directoryId, name);
    }

    public BatchResult<String> removeAllGroups(long directoryId, Set<String> groupNames) {
        Collection internalGroups = this.batchFinder.find(directoryId, groupNames, InternalGroup.class);
        HashSet<String> groupsToBeRemoved = new HashSet<String>(groupNames);
        BatchResult result = new BatchResult(internalGroups.size());
        for (InternalGroup internalGroup : internalGroups) {
            try {
                this.remove((Group)internalGroup);
                groupsToBeRemoved.remove(internalGroup.getName());
                result.addSuccess((Object)internalGroup.getName());
            }
            catch (GroupNotFoundException groupNotFoundException) {}
        }
        result.addFailures(groupsToBeRemoved);
        return result;
    }

    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        Directory directory = this.directoryDao.get().findById(directoryId);
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(String.class);
        Root root = query.from(InternalGroup.class);
        query.select((Selection)root.get("externalId")).where((Expression)builder.and(new Predicate[]{builder.equal((Expression)root.get("directory"), (Object)directory), builder.isFalse((Expression)root.get("local")), builder.isNotNull((Expression)root.get("externalId"))}));
        List result = session.createQuery(query).getResultList();
        if (result == null || result.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet(result));
    }

    public long getGroupCount(long directoryId) throws DirectoryNotFoundException {
        Directory directory = this.directoryDao.get().findById(directoryId);
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root root = query.from(InternalGroup.class);
        query.select((Selection)builder.count((Expression)root)).where((Expression)builder.equal((Expression)root.get("directory"), (Object)directory));
        return (Long)session.createQuery(query).uniqueResult();
    }

    public Set<String> getLocalGroupNames(long directoryId) throws DirectoryNotFoundException {
        Directory directory = this.directoryDao.get().findById(directoryId);
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(String.class);
        Root root = query.from(InternalGroup.class);
        query.select((Selection)root.get("name")).where((Expression)builder.and((Expression)builder.equal((Expression)root.get("directory"), (Object)directory), (Expression)builder.isTrue((Expression)root.get("local"))));
        List result = session.createQuery(query).getResultList();
        if (result == null || result.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet(result));
    }

    public Map<String, String> findByExternalIds(long directoryId, Set<String> externalIds) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createTupleQuery();
        Root group = query.from(InternalGroup.class);
        query.multiselect(new Selection[]{group.get("externalId").alias("externalId"), group.get("name").alias("name")});
        query.where((Expression)builder.and((Expression)builder.equal((Expression)group.get("directory").get("id"), (Object)directoryId), (Expression)group.get("externalId").in(externalIds)));
        try (Stream stream = session.createQuery(query).stream();){
            Map<String, String> map = stream.collect(Collectors.toMap(t -> (String)t.get("externalId", String.class), t -> (String)t.get("name", String.class)));
            return map;
        }
    }

    public Map<String, String> findExternalIdsByNames(long directoryId, Set<String> groupNames) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createTupleQuery();
        Root group = query.from(InternalGroup.class);
        query.multiselect(new Selection[]{group.get("externalId").alias("externalId"), group.get("name").alias("name")});
        query.where((Expression)builder.and((Expression)builder.equal((Expression)group.get("directory").get("id"), (Object)directoryId), (Expression)group.get("name").in(groupNames)));
        try (Stream stream = session.createQuery(query).stream();){
            Map<String, String> map = stream.collect(Collectors.toMap(t -> (String)t.get("name", String.class), t -> (String)t.get("externalId", String.class)));
            return map;
        }
    }

    public long getExternalGroupCount(long directoryId) throws DirectoryNotFoundException {
        Directory directory = this.directoryDao.get().findById(directoryId);
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root group = query.from(InternalGroup.class);
        query.select((Selection)builder.count((Expression)group));
        query.where((Expression)builder.and((Expression)builder.equal((Expression)group.get("directory"), (Object)directory), (Expression)builder.isFalse((Expression)group.get("local"))));
        return (Long)session.createQuery(query).uniqueResult();
    }

    public GroupWithAttributes findByNameWithAttributes(long directoryId, String name) throws GroupNotFoundException {
        InternalGroup group = this.internalFindByName(directoryId, name);
        return this.populateAttributes(group);
    }

    private Map<String, Set<String>> convertToAttributesMap(Iterable<InternalGroupAttribute> attributesList) {
        HashMap<String, Set<String>> attributesMap = new HashMap<String, Set<String>>();
        for (InternalGroupAttribute internalGroupAttribute : attributesList) {
            if (!attributesMap.containsKey(internalGroupAttribute.getName())) {
                attributesMap.put(internalGroupAttribute.getName(), new HashSet());
            }
            ((Set)attributesMap.get(internalGroupAttribute.getName())).add(internalGroupAttribute.getValue());
        }
        return attributesMap;
    }

    private InternalGroup add(Group group, boolean local) throws DirectoryNotFoundException {
        InternalGroup groupToSave = new InternalGroup(group, this.directoryDao.get().findById(group.getDirectoryId()));
        groupToSave.setLocal(local);
        groupToSave.setCreatedDateToNow();
        groupToSave.setUpdatedDateToNow();
        this.sessionFactory.getCurrentSession().save((Object)groupToSave);
        return groupToSave;
    }

    public BatchResult<Group> addAll(Set<? extends Group> groups) throws DirectoryNotFoundException {
        HashSet<InternalGroup> groupsToAdd = new HashSet<InternalGroup>();
        HashSet<Group> groupsFailedValidation = new HashSet<Group>();
        for (Group group : groups) {
            try {
                InternalGroup groupToAdd = new InternalGroup(group, this.directoryDao.get().findById(group.getDirectoryId()));
                groupToAdd.setCreatedDateToNow();
                groupToAdd.setUpdatedDateToNow();
                groupsToAdd.add(groupToAdd);
            }
            catch (IllegalArgumentException e) {
                log.error("Could not add group <{}>: ", (Object)group.getName(), (Object)e);
                groupsFailedValidation.add(group);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute((HibernateOperation)new SaveOrUpdateOperation(), groupsToAdd);
        if (!daoResult.getFailedEntities().isEmpty()) {
            log.info("The following groups could not be processed:");
            for (InternalGroup entity : daoResult.getFailedEntities()) {
                log.info(entity.getName());
            }
            log.info("Please try to resolve any errors with these groups, and try again.");
        }
        BatchResult batchResult = new BatchResult(groups.size());
        batchResult.addSuccesses((Collection)daoResult.getSuccessfulEntities());
        batchResult.addFailures((Collection)daoResult.getFailedEntities());
        batchResult.addFailures(groupsFailedValidation);
        return batchResult;
    }

    @Override
    public InternalGroup add(Group group) throws DirectoryNotFoundException {
        return this.add(group, false);
    }

    @Override
    public InternalGroup addLocal(Group group) throws DirectoryNotFoundException {
        return this.add(group, true);
    }

    public Group update(Group group) throws GroupNotFoundException {
        InternalGroup groupToUpdate = this.internalFindByGroup(group);
        groupToUpdate.updateDetailsFrom(group);
        groupToUpdate.setUpdatedDateToNow();
        this.sessionFactory.getCurrentSession().update((Object)groupToUpdate);
        return groupToUpdate;
    }

    public Group rename(Group group, String newName) throws GroupNotFoundException {
        InternalGroup groupToRename = this.internalFindByGroup(group);
        groupToRename.renameTo(newName);
        groupToRename.setUpdatedDateToNow();
        this.sessionFactory.getCurrentSession().update((Object)groupToRename);
        return groupToRename;
    }

    @Override
    public InternalGroup internalFindByGroup(Group group) throws GroupNotFoundException {
        return this.internalFindByName(group.getDirectoryId(), group.getName());
    }

    @Override
    public void removeAllGroups(long directoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        session.createQuery("from InternalGroupAttribute groupAttribute where groupAttribute.directory.id = :directoryId", InternalGroupAttribute.class).setParameter("directoryId", (Object)directoryId).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
        session.createQuery("from InternalGroup internalGroup where internalGroup.directory.id = :directoryId", InternalGroup.class).setParameter("directoryId", (Object)directoryId).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    public void storeAttributes(Group group, Map<String, Set<String>> attributes) throws GroupNotFoundException {
        InternalGroup internalGroup = this.internalFindByGroup(group);
        List<InternalGroupAttribute> attributesList = this.findGroupAttributes(internalGroup.getId());
        HashMap<String, Set> existingAttributesMap = new HashMap<String, Set>();
        for (InternalGroupAttribute internalGroupAttribute : attributesList) {
            Set existingVals = existingAttributesMap.computeIfAbsent(internalGroupAttribute.getName(), k -> new HashSet());
            existingVals.add(internalGroupAttribute);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            if (!existingAttributesMap.containsKey(entry.getKey())) {
                for (String newVal : (Set)entry.getValue()) {
                    internalGroup.getAttributes().add(this.addAttribute(internalGroup, (String)entry.getKey(), newVal));
                }
                continue;
            }
            Set newVals = (Set)entry.getValue();
            Set existingVals = (Set)existingAttributesMap.get(entry.getKey());
            ArrayList<String> valsToAdd = new ArrayList<String>();
            HashSet<InternalGroupAttribute> valsToRemove = new HashSet<InternalGroupAttribute>(existingVals);
            this.resolveNoOps(newVals, existingVals, valsToAdd, valsToRemove);
            for (InternalGroupAttribute existingVal : valsToRemove) {
                if (valsToAdd.isEmpty()) {
                    internalGroup.getAttributes().remove(existingVal);
                    this.sessionFactory.getCurrentSession().delete((Object)existingVal);
                    continue;
                }
                String newVal = (String)valsToAdd.remove(0);
                existingVal.setValue(newVal);
                this.sessionFactory.getCurrentSession().saveOrUpdate((Object)existingVal);
            }
            for (String newVal : valsToAdd) {
                internalGroup.getAttributes().add(this.addAttribute(internalGroup, (String)entry.getKey(), newVal));
            }
        }
    }

    private void resolveNoOps(Set<String> newVals, Set<InternalGroupAttribute> existingVals, List<String> valsToAdd, Set<InternalGroupAttribute> valsToRemove) {
        for (String newVal : newVals) {
            boolean valueAlreadyExists = false;
            for (InternalGroupAttribute existingVal : existingVals) {
                if (!newVal.equals(existingVal.getValue())) continue;
                valsToRemove.remove(existingVal);
                valueAlreadyExists = true;
                break;
            }
            if (valueAlreadyExists) continue;
            valsToAdd.add(newVal);
        }
    }

    private InternalGroupAttribute addAttribute(InternalGroup group, String attributeName, String attributeValue) {
        InternalGroupAttribute attribute = new InternalGroupAttribute(group, attributeName, attributeValue);
        this.sessionFactory.getCurrentSession().save((Object)attribute);
        return attribute;
    }

    private InternalGroupWithAttributes populateAttributes(InternalGroup group) {
        Set attributes = group.getAttributes();
        return new InternalGroupWithAttributes(group, this.convertToAttributesMap(attributes));
    }

    public void removeAttribute(Group group, String attributeName) throws GroupNotFoundException {
        InternalGroup internalGroup = this.internalFindByGroup(group);
        internalGroup.getAttributes().removeIf(attribute -> attributeName.equals(attribute.getName()));
        Session session = this.sessionFactory.getCurrentSession();
        session.createQuery("from InternalGroupAttribute a where a.group.id = :groupId and a.name = :attributeName", InternalGroupAttribute.class).setParameter("groupId", (Object)internalGroup.getId()).setParameter("attributeName", (Object)attributeName).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    private void removeAllAttributes(InternalGroup internalGroup) {
        Session session = this.sessionFactory.getCurrentSession();
        session.createQuery("from InternalGroupAttribute a where a.group.id = :groupId", InternalGroupAttribute.class).setParameter("groupId", (Object)internalGroup.getId()).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    public void remove(Group group) throws GroupNotFoundException {
        InternalGroup groupToRemove = (InternalGroup)this.findByName(group.getDirectoryId(), group.getName());
        this.membershipDao.removeAllGroupRelationships(groupToRemove);
        this.removeAllAttributes(groupToRemove);
        this.sessionFactory.getCurrentSession().delete((Object)groupToRemove);
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("GroupDAO can only evaluate EntityQueries for Entity.GROUP");
        }
        return HibernateSearch.forEntities(directoryId, query).doInHibernate(this.sessionFactory.getCurrentSession());
    }

    private List<InternalGroupAttribute> findGroupAttributes(long groupId) {
        Session session = this.sessionFactory.getCurrentSession();
        return session.createQuery(HibernateGroupDao.createFindAttributeByIdQuery(session, groupId)).list();
    }

    private static CriteriaQuery<InternalGroupAttribute> createFindAttributeByIdQuery(Session session, long groupId) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(InternalGroupAttribute.class);
        Root attr = query.from(InternalGroupAttribute.class);
        return query.where((Expression)builder.equal((Expression)attr.get("group").get("id"), (Object)groupId));
    }

    @Override
    public InternalGroup internalFindByName(long directoryId, String name) throws GroupNotFoundException {
        Session session = this.sessionFactory.getCurrentSession();
        InternalGroup result = (InternalGroup)session.createQuery(HibernateGroupDao.createFindGroupByNameQuery(session, directoryId, name)).uniqueResult();
        if (result == null) {
            throw new GroupNotFoundException(name);
        }
        return result;
    }

    private static CriteriaQuery<InternalGroup> createFindGroupByNameQuery(Session session, long directoryId, String name) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(InternalGroup.class);
        Root group = query.from(InternalGroup.class);
        return query.where((Expression)builder.and((Expression)builder.equal((Expression)group.get("lowerName"), (Object)IdentifierUtils.toLowerCase((String)name)), (Expression)builder.equal((Expression)group.get("directory").get("id"), (Object)directoryId)));
    }
}

