/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.hibernate;

import com.atlassian.crowd.dao.tombstone.TombstoneDao;
import com.atlassian.crowd.model.tombstone.AbstractTombstone;
import com.atlassian.crowd.model.tombstone.AliasTombstone;
import com.atlassian.crowd.model.tombstone.ApplicationTombstone;
import com.atlassian.crowd.model.tombstone.ApplicationUpdatedTombstone;
import com.atlassian.crowd.model.tombstone.EventStreamTombstone;
import com.atlassian.crowd.model.tombstone.GroupMembershipTombstone;
import com.atlassian.crowd.model.tombstone.GroupTombstone;
import com.atlassian.crowd.model.tombstone.UserMembershipTombstone;
import com.atlassian.crowd.model.tombstone.UserTombstone;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public final class HibernateTombstoneDao
implements TombstoneDao {
    private final Clock clock;
    private final SessionFactory sessionFactory;

    public HibernateTombstoneDao(Clock clock, SessionFactory sessionFactory) {
        this.clock = clock;
        this.sessionFactory = sessionFactory;
    }

    public void storeUserTombstones(long directoryId, Collection<String> names) {
        long timestamp = this.clock.millis();
        this.storeTombstones(names.stream().map(name -> new UserTombstone(timestamp, name, directoryId))::iterator);
    }

    public void storeGroupTombstones(long directoryId, Collection<String> names) {
        long timestamp = this.clock.millis();
        this.storeTombstones(names.stream().map(name -> new GroupTombstone(timestamp, name, directoryId))::iterator);
    }

    public void storeUserMembershipTombstone(long directoryId, String username, String parentGroupName) {
        long timestamp = this.clock.millis();
        this.storeTombstones(Collections.singleton(new UserMembershipTombstone(timestamp, username, parentGroupName, directoryId)));
    }

    public void storeGroupMembershipTombstone(long directoryId, String childGroupName, String parentGroupName) {
        long timestamp = this.clock.millis();
        this.storeTombstones(Collections.singleton(new GroupMembershipTombstone(timestamp, childGroupName, parentGroupName, directoryId)));
    }

    public void storeEventsTombstoneForDirectory(String reason, long directoryId) {
        long timestamp = this.clock.millis();
        this.storeTombstones(Collections.singleton(EventStreamTombstone.createForDirectory((long)timestamp, (long)directoryId, (String)reason)));
    }

    public void storeEventsTombstoneForApplication(long applicationId) {
        long timestamp = this.clock.millis();
        this.storeTombstones(Collections.singleton(new ApplicationUpdatedTombstone(timestamp, applicationId)));
    }

    public void storeEventsTombstone(String reason) {
        long timestamp = this.clock.millis();
        this.storeTombstones(Collections.singleton(EventStreamTombstone.createGlobal((long)timestamp, (String)reason)));
    }

    public void storeAliasTombstone(long applicationId, String username) {
        long timestamp = this.clock.millis();
        this.storeTombstones(Collections.singleton(new AliasTombstone(timestamp, applicationId, username)));
    }

    private <T extends AbstractTombstone> void storeTombstones(Iterable<T> tombstones) {
        tombstones.forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).save(arg_0));
    }

    public <T extends AbstractTombstone> List<T> getTombstonesAfter(long after, Collection<Long> directoryIds, Class<T> type) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(type);
        Root root = query.from(type);
        if (directoryIds.isEmpty()) {
            query.where((Expression)builder.gt((Expression)root.get("timestamp"), (Number)after));
        } else {
            query.where((Expression)builder.and((Expression)builder.gt((Expression)root.get("timestamp"), (Number)after), (Expression)builder.or((Expression)root.get("directoryId").in(directoryIds), (Expression)root.get("directoryId").isNull())));
        }
        query.orderBy(new Order[]{builder.asc((Expression)root.get("timestamp"))});
        return session.createQuery(query).getResultList();
    }

    public <T extends ApplicationTombstone> List<T> getTombstonesAfter(long after, Long applicationId, Class<T> type) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(type);
        Root root = query.from(type);
        query.where((Expression)builder.and((Expression)builder.gt((Expression)root.get("timestamp"), (Number)after), (Expression)builder.equal((Expression)root.get("applicationId"), (Object)applicationId))).orderBy(new Order[]{builder.asc((Expression)root.get("timestamp"))});
        return session.createQuery(query).getResultList();
    }

    public int removeAllUpTo(long timestamp) {
        return this.sessionFactory.getCurrentSession().createQuery("delete from AbstractTombstone where timestamp <= :timestamp").setParameter("timestamp", (Object)timestamp).executeUpdate();
    }
}

