/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.serviceaccount;

import com.atlassian.crowd.dao.service.ServiceAccountManagerDAOHibernate;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.model.service.InternalServiceAccount;
import com.atlassian.crowd.model.service.InternalServiceAccountAuthMethod;
import org.hibernate.SessionFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ConfluenceServiceAccountDao
extends ServiceAccountManagerDAOHibernate {
    public ConfluenceServiceAccountDao(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public boolean updateServiceAccount(InternalServiceAccount serviceAccountUpdate) {
        boolean updated = super.updateServiceAccount(serviceAccountUpdate);
        if (updated && serviceAccountUpdate.getAuthMethods() != null && !serviceAccountUpdate.getAuthMethods().isEmpty()) {
            InternalServiceAccountAuthMethod authMethod = (InternalServiceAccountAuthMethod)serviceAccountUpdate.getAuthMethods().iterator().next();
            this.session().saveOrUpdate((Object)authMethod);
        }
        return updated;
    }

    public void deleteAuth(ServiceAccount serviceAccount, String authId, String authType) {
        this.session().createQuery("DELETE FROM InternalServiceAccountAuthMethod am WHERE am.serviceAccount.id = :serviceAccountId AND am.authId = :authId AND am.authType = :authType").setParameter("serviceAccountId", (Object)serviceAccount.getId()).setParameter("authId", (Object)authId).setParameter("authType", (Object)authType).executeUpdate();
    }
}

