/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.serviceaccount;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ConfluenceResourceType;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountResourceTypeDescriptorImpl;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountSpaceResourceDescriptionImpl;
import com.atlassian.confluence.internal.search.v2.lucene.LuceneQueryUtil;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.crowd.embedded.api.Page;
import com.atlassian.crowd.embedded.api.PageRequest;
import com.atlassian.crowd.embedded.api.service.Resource;
import com.atlassian.crowd.embedded.spi.service.ResourceDescription;
import com.atlassian.crowd.embedded.spi.service.ResourceTypeDescription;
import com.atlassian.crowd.embedded.spi.service.RestrictedResourcesProvider;
import com.atlassian.crowd.search.PageImpl;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedResourcesProviderImpl
implements RestrictedResourcesProvider {
    private static final Logger log = LoggerFactory.getLogger(RestrictedResourcesProviderImpl.class);
    private final PredefinedSearchBuilder searchBuilder;
    private final SearchManager searchManager;
    private final SpaceManagerInternal spaceManager;
    private final I18NBeanFactory i18NBeanFactory;

    public RestrictedResourcesProviderImpl(PredefinedSearchBuilder searchBuilder, SearchManager searchManager, SpaceManagerInternal spaceManager, I18NBeanFactory i18NBeanFactory) {
        this.searchBuilder = searchBuilder;
        this.searchManager = searchManager;
        this.spaceManager = spaceManager;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    public List<ResourceTypeDescription> getAllResourceTypes() {
        return Arrays.stream(ConfluenceResourceType.values()).map(ServiceAccountResourceTypeDescriptorImpl::from).toList();
    }

    public Page<ResourceDescription> findResources(String resourceTypeId, String searchText, PageRequest pageRequest) {
        if (ConfluenceResourceType.SPACES.getResourceTypeId().equals(resourceTypeId)) {
            return this.findSpaces(searchText, pageRequest);
        }
        throw new IllegalArgumentException("Unsupported resource type: " + resourceTypeId);
    }

    public ResourceDescription getResource(String resourceTypeId, String resourceId) {
        if (ConfluenceResourceType.SPACES.getResourceTypeId().equals(resourceTypeId)) {
            Space space = this.getSpace(resourceId);
            if (space != null) {
                return new ServiceAccountSpaceResourceDescriptionImpl(space, space.getKey(), this.i18NBeanFactory);
            }
            log.info("Space with ID [{}] not found, returning unknown space resource for service account.", (Object)resourceId);
            return new ServiceAccountSpaceResourceDescriptionImpl(null, resourceId, this.i18NBeanFactory);
        }
        throw new IllegalArgumentException("Unsupported resource type: " + resourceTypeId);
    }

    public List<ResourceDescription> getResources(List<Resource> resources) {
        return List.of();
    }

    private Space getSpace(String spaceKey) {
        Space space = null;
        try {
            space = this.spaceManager.getSpace(spaceKey);
        }
        catch (Exception ex) {
            log.error("Failed to get space with key [{}]", (Object)spaceKey, (Object)ex);
        }
        return space;
    }

    private Page<ResourceDescription> findSpaces(String searchText, PageRequest pageRequest) {
        int offset = pageRequest.start();
        int limit = pageRequest.limit();
        String searchQuery = RestrictedResourcesProviderImpl.spaceSearchQuery(searchText);
        SearchQueryParameters params = new SearchQueryParameters(searchQuery);
        params.setContentTypes((Set<ContentTypeEnum>)ImmutableSet.of((Object)((Object)ContentTypeEnum.SPACE_DESCRIPTION), (Object)((Object)ContentTypeEnum.PERSONAL_SPACE_DESCRIPTION)));
        params.setSort(TitleSort.ASCENDING);
        ISearch search = this.searchBuilder.buildSiteSearch(params, offset, limit);
        try {
            SearchResults results = this.searchManager.search(search);
            Set<String> foundSpaceKeys = results.getAll().stream().map(SearchResult::getSpaceKey).collect(Collectors.toSet());
            SpacesQuery spaceQuery = SpacesQuery.newQuery().withSpaceKeys(foundSpaceKeys).build();
            List matchingSpaces = this.spaceManager.getSpaces(spaceQuery, LimitedRequestImpl.create((int)limit), x -> true).getResults();
            Map spaceByKey = matchingSpaces.stream().collect(Collectors.toMap(Space::getKey, Function.identity()));
            List resources = results.getAll().stream().filter(r -> spaceByKey.containsKey(r.getSpaceKey())).map(r -> new ServiceAccountSpaceResourceDescriptionImpl((Space)spaceByKey.get(r.getSpaceKey()), r.getSpaceKey(), this.i18NBeanFactory)).collect(Collectors.toList());
            return new PageImpl(resources, offset + limit, limit, results.getUnfilteredResultsCount(), results.isLastPage());
        }
        catch (InvalidSearchException e) {
            throw new RuntimeException("Unable to perform spaces search for service accounts view", e);
        }
    }

    @VisibleForTesting
    static @NonNull String spaceSearchQuery(@Nullable String searchText) {
        return Optional.ofNullable(searchText).filter(StringUtils::isNotBlank).map(LuceneQueryUtil::safeEscape).map(t -> t + "*").orElse("");
    }
}

