/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.serviceaccount;

import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountUserManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UnknownUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.crowd.embedded.api.service.Resource;
import com.atlassian.crowd.embedded.api.service.ResourceType;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.model.service.ServiceAccountImpl;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import io.atlassian.util.concurrent.Suppliers;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServiceAccountUserImpl
extends ConfluenceUserImpl
implements ServiceAccount {
    private transient Supplier<ServiceAccount> backingUserSupplier;
    private transient User defaultBackingUser = null;
    private static final long serialVersionUID = -7128183776011419831L;
    private static final String SERVICE_ACCOUNT_EMAIL = "";
    private static final String UNKNOWN_SERVICE_ACCOUNT_NAME = "Unknown Service Account";
    private Supplier<ServiceAccountUserManager> serviceAccountUserManager;

    public ServiceAccountUserImpl() {
    }

    public ServiceAccountUserImpl(ConfluenceUser confluenceUser, Long id, boolean active, @NonNull String name, String displayName, String description, Map<ResourceType, Set<Resource>> resourceRestrictions) {
        this(confluenceUser, (ServiceAccount)ServiceAccountImpl.builder((String)name).id(id).active(active).displayName(displayName).description(description).resourceRestrictions(resourceRestrictions).build());
    }

    public ServiceAccountUserImpl(ConfluenceUser confluenceUser, @NonNull ServiceAccount serviceAccount) {
        super(serviceAccount.getName(), serviceAccount.getDisplayName(), SERVICE_ACCOUNT_EMAIL);
        this.setBackingUserSupplier(serviceAccount);
        if (confluenceUser != null) {
            this.setKey(confluenceUser.getKey());
        }
    }

    protected ServiceAccountUserImpl(@NonNull ConfluenceUser confluenceUser) {
        super(confluenceUser.getName(), confluenceUser.getFullName(), SERVICE_ACCOUNT_EMAIL);
        this.setKey(confluenceUser.getKey());
        this.setLowerName(confluenceUser.getLowerName());
    }

    public static Optional<ServiceAccountUserImpl> toServiceAccountUserImpl(@NonNull ConfluenceUser confluenceUser) {
        if (confluenceUser instanceof ServiceAccountUserImpl) {
            return Optional.of((ServiceAccountUserImpl)confluenceUser);
        }
        ServiceAccountUserImpl serviceAccountUser = new ServiceAccountUserImpl(confluenceUser);
        if (serviceAccountUser.tryResolveServiceAccount() != null) {
            return Optional.of(serviceAccountUser);
        }
        return Optional.empty();
    }

    private void setBackingUserSupplier(ServiceAccount serviceAccount) {
        this.backingUserSupplier = Suppliers.memoize((Object)serviceAccount);
        this.defaultBackingUser = new DefaultUser(serviceAccount.getName(), serviceAccount.getDisplayName(), SERVICE_ACCOUNT_EMAIL);
    }

    @Override
    public User getBackingUser() {
        if (this.defaultBackingUser == null) {
            ServiceAccount serviceAccount = this.tryResolveServiceAccount();
            if (serviceAccount != null) {
                this.defaultBackingUser = new DefaultUser(serviceAccount.getName(), serviceAccount.getDisplayName(), SERVICE_ACCOUNT_EMAIL);
            } else {
                String fallbackName = this.getFallbackName();
                this.defaultBackingUser = UnknownUser.unknownUser(fallbackName, GeneralUtil.getI18n());
            }
        }
        return this.defaultBackingUser;
    }

    protected void resetServiceAccountUserSupplier() {
        if (this.serviceAccountUserManager == null) {
            this.serviceAccountUserManager = MemoizingComponentReference.containerComponent("serviceAccountUserManager");
        }
        Optional<ServiceAccount> serviceAccount = this.serviceAccountUserManager.get().getServiceAccount(this.lowerName);
        serviceAccount.ifPresent(this::setBackingUserSupplier);
    }

    public @NonNull ServiceAccount getServiceAccount() {
        ServiceAccount serviceAccount = this.tryResolveServiceAccount();
        if (serviceAccount != null) {
            return serviceAccount;
        }
        String fallbackName = this.getFallbackName();
        return ServiceAccountImpl.builder((String)fallbackName).active(false).displayName(fallbackName).description(null).resourceRestrictions(Collections.emptyMap()).build();
    }

    @Override
    public void setLowerName(@Nullable String lowerName) {
        this.lowerName = lowerName;
        this.resetServiceAccountUserSupplier();
    }

    public Long getId() {
        return this.getServiceAccount().getId();
    }

    public boolean isActive() {
        return this.getServiceAccount().isActive();
    }

    public String getDisplayName() {
        ServiceAccount serviceAccount = this.tryResolveServiceAccount();
        if (serviceAccount != null) {
            return serviceAccount.getDisplayName();
        }
        return super.getFullName();
    }

    public String getDescription() {
        return this.getServiceAccount().getDescription();
    }

    public Map<ResourceType, Set<Resource>> getResourceRestrictions() {
        return this.getServiceAccount().getResourceRestrictions();
    }

    @Override
    public String getFullName() {
        ServiceAccount serviceAccount = this.tryResolveServiceAccount();
        if (serviceAccount != null) {
            return serviceAccount.getDisplayName();
        }
        return super.getFullName();
    }

    @Override
    public String getEmail() {
        return SERVICE_ACCOUNT_EMAIL;
    }

    @Override
    public boolean isServiceAccount() {
        return true;
    }

    private ServiceAccount tryResolveServiceAccount() {
        try {
            if (this.backingUserSupplier == null) {
                this.resetServiceAccountUserSupplier();
            }
            return this.backingUserSupplier != null ? this.backingUserSupplier.get() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private String getFallbackName() {
        return this.getName() != null ? this.getName() : (this.lowerName != null ? this.lowerName : UNKNOWN_SERVICE_ACCOUNT_NAME);
    }

    @Override
    public ServiceAccountUserImpl clone() throws CloneNotSupportedException {
        return (ServiceAccountUserImpl)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountUserImpl that = (ServiceAccountUserImpl)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getLowerName(), that.getLowerName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getLowerName());
    }
}

