/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.crowd.serviceaccount;

import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountUserImpl;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountUserManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.crowd.embedded.api.OAuth2Method;
import com.atlassian.crowd.embedded.api.Page;
import com.atlassian.crowd.embedded.api.PageRequest;
import com.atlassian.crowd.embedded.api.authentication.AuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthService;
import com.atlassian.crowd.embedded.api.service.ServiceAccountManager;
import com.atlassian.crowd.embedded.api.service.ServiceAccountQuery;
import com.atlassian.crowd.model.service.ServiceAccountAuthMethodImpl;
import java.util.Optional;

final class ServiceAccountUserManagerImpl
implements ServiceAccountUserManager {
    private final ServiceAccountAuthService authService;
    private final ConfluenceUserDao userDao;
    private final ServiceAccountManager serviceAccountManager;

    ServiceAccountUserManagerImpl(ServiceAccountAuthService authService, ConfluenceUserDao userDao, ServiceAccountManager serviceAccountManager) {
        this.authService = authService;
        this.userDao = userDao;
        this.serviceAccountManager = serviceAccountManager;
    }

    @Override
    public ServiceAccountUserImpl getServiceAccountUserForOAuthClient(String clientId) {
        Optional serviceAccountOptional;
        ServiceAccountUserImpl serviceAccountUser = null;
        if (clientId != null && (serviceAccountOptional = this.authService.findByAuthMethod((ServiceAccountAuthMethod)new ServiceAccountAuthMethodImpl(clientId, (AuthMethod)new OAuth2Method()))).isPresent()) {
            ConfluenceUser confluenceUser = this.userDao.findByUsername(((ServiceAccount)serviceAccountOptional.get()).getName());
            serviceAccountUser = new ServiceAccountUserImpl(confluenceUser, (ServiceAccount)serviceAccountOptional.get());
        }
        return serviceAccountUser;
    }

    @Override
    public Optional<ServiceAccount> getServiceAccount(String userName) {
        if (userName != null) {
            return this.serviceAccountManager.getServiceAccountByName(userName);
        }
        return Optional.empty();
    }

    @Override
    public Page<ServiceAccount> findServiceAccounts(ServiceAccountQuery query, PageRequest request) {
        if (query == null || request == null) {
            throw new IllegalArgumentException("Query and PageRequest must not be null");
        }
        return this.serviceAccountManager.findServiceAccounts(query, request);
    }
}

