/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.preferences;

import com.atlassian.confluence.impl.user.preferences.UserPreferenceDefaults;
import com.atlassian.confluence.user.UserPreferences;
import java.util.Optional;
import java.util.function.Supplier;

public class AnonymousUserPreferences
implements UserPreferences {
    private static final Supplier<UserPreferences.PreferenceException> mutateException = () -> new UserPreferences.PreferenceException("Anonymous user preferences are read-only", new UnsupportedOperationException());

    @Override
    public Optional<String> getString(String key) {
        return Optional.ofNullable(UserPreferenceDefaults.STRING_DEFAULTS.get(key));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        return Optional.ofNullable(UserPreferenceDefaults.BOOLEAN_DEFAULTS.get(key));
    }

    @Override
    public Optional<Long> getLong(String key) {
        return Optional.ofNullable(UserPreferenceDefaults.LONG_DEFAULTS.get(key));
    }

    @Override
    public void setString(String key, String value) {
        throw mutateException.get();
    }

    @Override
    public void setLong(String key, long value) {
        throw mutateException.get();
    }

    @Override
    public void setBoolean(String key, boolean value) {
        throw mutateException.get();
    }

    @Override
    public void remove(String key) {
        throw mutateException.get();
    }
}

