/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.preferences;

import com.atlassian.confluence.impl.user.preferences.UserPreferenceDefaults;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreference;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreferencesDao;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.sal.api.user.UserKey;
import java.util.Optional;

public class UserPreferencesImpl
implements UserPreferences {
    private final UserKey userKey;
    private final UserPreferencesDao userPreferencesDao;

    public UserPreferencesImpl(UserKey userKey, UserPreferencesDao userPreferencesDao) {
        this.userKey = userKey;
        this.userPreferencesDao = userPreferencesDao;
    }

    @Override
    public Optional<String> getString(String key) {
        return this.userPreferencesDao.getUserPreference(this.userKey, key).map(UserPreference::stringValue).or(() -> Optional.ofNullable(UserPreferenceDefaults.STRING_DEFAULTS.get(key)));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        return this.userPreferencesDao.getUserPreference(this.userKey, key).map(UserPreference::booleanValue).or(() -> Optional.ofNullable(UserPreferenceDefaults.BOOLEAN_DEFAULTS.get(key)));
    }

    @Override
    public Optional<Long> getLong(String key) {
        return this.userPreferencesDao.getUserPreference(this.userKey, key).map(UserPreference::longValue).or(() -> Optional.ofNullable(UserPreferenceDefaults.LONG_DEFAULTS.get(key)));
    }

    @Override
    public void setString(String key, String value) {
        this.userPreferencesDao.setUserPreference(this.userKey, key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.userPreferencesDao.setUserPreference(this.userKey, key, value);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.userPreferencesDao.setUserPreference(this.userKey, key, value);
    }

    @Override
    public void remove(String key) {
        this.userPreferencesDao.removeUserPreference(this.userKey, key);
    }
}

