/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.preferences.dao;

import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.impl.cache.ReadThroughAtlassianCache;
import com.atlassian.confluence.impl.cache.ReadThroughCache;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreference;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreferencesDao;
import com.atlassian.sal.api.user.UserKey;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class CachingUserPreferencesDao
implements UserPreferencesDao {
    private final UserPreferencesDao delegate;
    private final ReadThroughCache<String, Option<UserPreference>> cache;
    private final ReadThroughCache<String, ?> legacyCache;

    public CachingUserPreferencesDao(UserPreferencesDao delegate, ReadThroughCache<String, Option<UserPreference>> cache, ReadThroughCache<String, ?> legacyCache) {
        this.delegate = delegate;
        this.cache = cache;
        this.legacyCache = legacyCache;
    }

    public static CachingUserPreferencesDao create(UserPreferencesDao delegate, CacheFactory cacheFactory) {
        return new CachingUserPreferencesDao(delegate, ReadThroughAtlassianCache.create(cacheFactory, CoreCache.USER_PREFERENCE_DAO), ReadThroughAtlassianCache.create(cacheFactory, CoreCache.USER_PROPERTY_SETS));
    }

    public static String cacheKey(UserKey userKey, String key) {
        return userKey.getStringValue() + "." + key;
    }

    private void removeFromCache(UserKey userKey, String key) {
        String cacheKey = CachingUserPreferencesDao.cacheKey(userKey, key);
        this.cache.remove(cacheKey);
        this.legacyCache.remove(cacheKey);
    }

    @Override
    public List<UserPreference> getUserPreferences(UserKey userKey) {
        return this.delegate.getUserPreferences(userKey);
    }

    @Override
    public Optional<UserPreference> getUserPreference(UserKey userKey, String key) {
        return this.cache.get(CachingUserPreferencesDao.cacheKey(userKey, key), () -> Option.fromOptional(this.delegate.getUserPreference(userKey, key))).toOptional();
    }

    @Override
    public Set<String> removeAllUserPreferences(UserKey userKey) {
        Set<String> deleted = this.delegate.removeAllUserPreferences(userKey);
        deleted.forEach(key -> this.removeFromCache(userKey, (String)key));
        return deleted;
    }

    @Override
    public void removeUserPreference(UserKey userKey, String key) {
        this.delegate.removeUserPreference(userKey, key);
        this.removeFromCache(userKey, key);
    }

    @Override
    public void setUserPreference(UserKey userKey, String key, String value) {
        this.delegate.setUserPreference(userKey, key, value);
        this.removeFromCache(userKey, key);
    }

    @Override
    public void setUserPreference(UserKey userKey, String key, boolean value) {
        this.delegate.setUserPreference(userKey, key, value);
        this.removeFromCache(userKey, key);
    }

    @Override
    public void setUserPreference(UserKey userKey, String key, long value) {
        this.delegate.setUserPreference(userKey, key, value);
        this.removeFromCache(userKey, key);
    }
}

