/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.preferences.dao;

import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UserPreference
implements Serializable {
    private final String key;
    private final PreferenceType valueType;
    private final String stringValue;
    private final Long longValue;
    private final Boolean booleanValue;

    public UserPreference(String key, String value) {
        this.key = Objects.requireNonNull(key);
        this.valueType = PreferenceType.STRING;
        this.stringValue = Objects.requireNonNull(value);
        this.longValue = null;
        this.booleanValue = null;
    }

    public UserPreference(String key, long value) {
        this.key = Objects.requireNonNull(key);
        this.valueType = PreferenceType.LONG;
        this.stringValue = null;
        this.longValue = value;
        this.booleanValue = null;
    }

    public UserPreference(String key, boolean value) {
        this.key = Objects.requireNonNull(key);
        this.valueType = PreferenceType.BOOLEAN;
        this.stringValue = null;
        this.longValue = null;
        this.booleanValue = value;
    }

    public @NonNull String key() {
        return this.key;
    }

    public @NonNull PreferenceType valueType() {
        return this.valueType;
    }

    public @Nullable String stringValue() {
        return this.stringValue;
    }

    public @Nullable Long longValue() {
        return this.longValue;
    }

    public @Nullable Boolean booleanValue() {
        return this.booleanValue;
    }

    public @NonNull Object value() {
        return switch (this.valueType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Objects.requireNonNull(this.stringValue());
            case 1 -> Objects.requireNonNull(this.longValue());
            case 2 -> Objects.requireNonNull(this.booleanValue());
        };
    }

    public static enum PreferenceType implements Serializable
    {
        STRING,
        LONG,
        BOOLEAN;

    }
}

