/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.preferences.dao;

import bucket.user.propertyset.BucketPropertySetItem;
import com.atlassian.confluence.impl.neops.NeoPropertySetItem;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreference;
import com.atlassian.confluence.impl.user.preferences.dao.UserPreferencesDao;
import com.atlassian.sal.api.user.UserKey;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class UserPreferencesDaoImpl
implements UserPreferencesDao {
    public static final String ENTITY_PREFIX = "USERPROPS-";
    public static final int OSPS_KEY_LENGTH_LIMIT = 200;
    public static final int OSPS_STR_COLUMN_LIMIT = 255;
    public static final int OSPS_TEXT_COLUMN_LIMIT = 100000;
    public static final String OSPS_QUERY = "from BucketPropertySetItem where entityName=:name and entityId=:id";
    public static final String OSPS_QUERY_KEYED = "from BucketPropertySetItem where entityName=:name and entityId=:id and key=:key";
    private final SessionFactory sessionFactory;

    public UserPreferencesDaoImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserPreference> getUserPreferences(UserKey userKey) {
        return this.findPropertySetItems(userKey).stream().map(UserPreferencesDaoImpl::fromPropertySetItem).filter(Objects::nonNull).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<UserPreference> getUserPreference(UserKey userKey, String key) {
        return this.findPropertySetItem(userKey, key).map(UserPreferencesDaoImpl::fromPropertySetItem);
    }

    @Override
    public Set<String> removeAllUserPreferences(UserKey userKey) {
        List<BucketPropertySetItem> items = this.findPropertySetItems(userKey);
        items.forEach(item -> this.sessionFactory.getCurrentSession().delete(item));
        return items.stream().map(NeoPropertySetItem::getKey).collect(Collectors.toSet());
    }

    @Override
    public void removeUserPreference(UserKey userKey, String key) {
        this.findPropertySetItem(userKey, key).ifPresent(item -> this.sessionFactory.getCurrentSession().delete(item));
    }

    @Override
    public void setUserPreference(UserKey userKey, String key, String value) {
        Validate.inclusiveBetween((long)0L, (long)100000L, (long)value.length());
        this.setUserPreference(userKey, key, (BucketPropertySetItem item) -> this.setString((BucketPropertySetItem)item, value));
    }

    @Override
    public void setUserPreference(UserKey userKey, String key, boolean value) {
        this.setUserPreference(userKey, key, (BucketPropertySetItem item) -> item.setBooleanVal(value));
    }

    @Override
    public void setUserPreference(UserKey userKey, String key, long value) {
        this.setUserPreference(userKey, key, (BucketPropertySetItem item) -> item.setLongVal(value));
    }

    private void setUserPreference(UserKey userKey, String key, Consumer<BucketPropertySetItem> mutator) {
        Validate.inclusiveBetween((long)1L, (long)200L, (long)key.length());
        Optional<BucketPropertySetItem> itemOpt = this.findPropertySetItem(userKey, key);
        BucketPropertySetItem item = itemOpt.orElseGet(() -> new BucketPropertySetItem(UserPreferencesDaoImpl.entityName(userKey), 0L, key));
        mutator.accept(item);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)item);
    }

    private List<BucketPropertySetItem> findPropertySetItems(UserKey userKey) {
        return this.sessionFactory.getCurrentSession().createQuery(OSPS_QUERY, BucketPropertySetItem.class).setParameter("name", (Object)UserPreferencesDaoImpl.entityName(userKey)).setParameter("id", (Object)0L).list();
    }

    private Optional<BucketPropertySetItem> findPropertySetItem(UserKey userKey, String key) {
        return this.sessionFactory.getCurrentSession().createQuery(OSPS_QUERY_KEYED, BucketPropertySetItem.class).setParameter("name", (Object)UserPreferencesDaoImpl.entityName(userKey)).setParameter("id", (Object)0L).setParameter("key", (Object)key).uniqueResultOptional();
    }

    private static String entityName(UserKey userKey) {
        return ENTITY_PREFIX + userKey.getStringValue();
    }

    private void setString(BucketPropertySetItem item, String value) {
        if (value.length() <= 255) {
            item.setStringVal(value);
        } else {
            item.setTextVal(value);
        }
    }

    private static @Nullable UserPreference fromPropertySetItem(BucketPropertySetItem item) {
        return switch (item.getPropertyType()) {
            case NeoPropertySetItem.PropertyType.STRING -> {
                if (item.getStringVal() != null) {
                    yield new UserPreference(item.getKey(), item.getStringVal());
                }
                yield null;
            }
            case NeoPropertySetItem.PropertyType.TEXT -> {
                if (item.getTextVal() != null) {
                    yield new UserPreference(item.getKey(), item.getTextVal());
                }
                yield null;
            }
            case NeoPropertySetItem.PropertyType.BOOLEAN -> new UserPreference(item.getKey(), item.getBooleanVal());
            case NeoPropertySetItem.PropertyType.LONG -> new UserPreference(item.getKey(), item.getLongVal());
            case NeoPropertySetItem.PropertyType.INT -> new UserPreference(item.getKey(), item.getIntVal());
            default -> null;
        };
    }
}

