/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.user.signup;

import com.atlassian.confluence.admin.criteria.MailServerExistsCriteria;
import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.content.datasource.ResourceModuleDescriptor;
import com.atlassian.confluence.impl.user.signup.EmailService;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.user.notifications.NotificationSendResult;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.user.User;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

class DefaultEmailService
implements EmailService {
    private final MultiQueueTaskManager taskManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final DataSourceFactory dataSourceFactory;
    private final VelocityHelperService velocityHelperService;
    private final MailServerExistsCriteria mailServerExistsCriteria;

    public DefaultEmailService(MultiQueueTaskManager taskManager, I18NBeanFactory i18NBeanFactory, DataSourceFactory dataSourceFactory, VelocityHelperService velocityHelperService, MailServerExistsCriteria mailServerExistsCriteria) {
        this.taskManager = taskManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.dataSourceFactory = dataSourceFactory;
        this.velocityHelperService = velocityHelperService;
        this.mailServerExistsCriteria = mailServerExistsCriteria;
    }

    @Override
    public NotificationSendResult sendToEmails(NotificationData notificationData, List<String> recipients) {
        if (!this.mailServerExistsCriteria.isMet()) {
            return new NotificationSendResult(new HashSet<String>(), Sets.newHashSet(recipients));
        }
        NotificationContext context = notificationData.cloneContext();
        context.putAll(this.velocityHelperService.createDefaultVelocityContext());
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        context.put("i18n", i18NBean);
        DataSource avatarDataSource = this.dataSourceFactory.getAvatar(FindUserHelper.getUser(notificationData.getModifier()));
        context.put("avatarCid", avatarDataSource.getName());
        context.addTemplateImage(avatarDataSource);
        String renderedSubject = this.velocityHelperService.getRenderedContent(notificationData.getSubject(), context.getMap());
        HashSet uniqueRecipients = Sets.newHashSet(recipients);
        uniqueRecipients = Sets.newHashSet((Iterable)Collections2.transform((Collection)uniqueRecipients, String::trim));
        uniqueRecipients.remove("");
        HashSet<String> failedRecipients = new HashSet<String>();
        for (String recipient : uniqueRecipients) {
            InternetAddress address;
            try {
                address = new InternetAddress(recipient, true);
            }
            catch (AddressException e) {
                failedRecipients.add(recipient);
                continue;
            }
            AnonymousUser anonymousUser = new AnonymousUser(address.getAddress());
            PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with(anonymousUser, notificationData.getTemplateName(), renderedSubject).andContext(context.getMap()).andRelatedBodyParts(context.getTemplateImageDataSources());
            builder.andRelatedBodyParts(this.imagesUsedByChromeTemplate());
            this.taskManager.addTask("mail", (Task)this.renderEmail(builder));
        }
        this.taskManager.flush("mail");
        uniqueRecipients.removeAll(failedRecipients);
        return new NotificationSendResult(uniqueRecipients, failedRecipients);
    }

    protected PreRenderedMailNotificationQueueItem renderEmail(PreRenderedMailNotificationQueueItem.Builder builder) {
        return builder.render();
    }

    private Iterable<DataSource> imagesUsedByChromeTemplate() {
        return this.dataSourceFactory.getResourcesFromModules(new ModuleCompleteKey("com.atlassian.confluence.plugins.confluence-email-resources", "chrome-template"), ResourceModuleDescriptor.Filters.IMAGE);
    }

    private static class AnonymousUser
    implements User {
        private final String email;

        private AnonymousUser(String email) {
            this.email = email;
        }

        public String getName() {
            return this.email;
        }

        public String getFullName() {
            return this.email;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

