/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.userstatus;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.userstatus.FavouriteManager;
import com.atlassian.confluence.util.LabelUtil;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class DefaultFavouriteManager
implements FavouriteManager {
    private final SpaceManager spaceManager;
    private final LabelManager labelManager;
    private final LabelPermissionEnforcer labelPermissionEnforcer;

    public DefaultFavouriteManager(SpaceManager spaceManager, LabelManager labelManager, LabelPermissionEnforcer labelPermissionEnforcer) {
        this.spaceManager = spaceManager;
        this.labelManager = labelManager;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
    }

    @Override
    public boolean isUserFavourite(ConfluenceUser user, Space space) {
        if (space == null || space.getDescription() == null || user == null) {
            return false;
        }
        return Optional.ofNullable(this.labelManager.getFavouriteLabellingsByContentIds(List.of(ContentId.of((long)space.getDescription().getId())), user.getKey())).map(matchingList -> !matchingList.isEmpty()).orElse(false);
    }

    @Override
    public void addSpaceToFavourites(ConfluenceUser user, Space space) {
        Preconditions.checkNotNull((Object)space);
        this.checkPermission(user, space.getDescription());
        if (space.getDescription() == null) {
            SpaceDescription spaceDescription = new SpaceDescription();
            spaceDescription.setSpace(space);
            spaceDescription.setBodyAsString("");
            space.setDescription(spaceDescription);
            this.spaceManager.saveSpace(space);
        }
        Label label = new Label("favourite", Namespace.PERSONAL, user);
        this.labelManager.addLabel(space.getDescription(), label);
    }

    @Override
    public void removeSpaceFromFavourites(ConfluenceUser user, Space space) {
        Preconditions.checkNotNull((Object)space);
        this.checkPermission(user, space.getDescription());
        this.removeSpaceFromFavourites(user, space, "favourite");
        this.removeSpaceFromFavourites(user, space, "favorite");
    }

    private void removeSpaceFromFavourites(ConfluenceUser user, Space space, String labelName) {
        Label label = this.labelManager.getLabel("~" + user.getName() + ":" + labelName);
        if (label == null) {
            return;
        }
        this.labelManager.removeLabel(space.getDescription(), label);
        LabelUtil.recordLabelInteractionInHistory(label);
    }

    @Override
    public boolean isUserFavourite(ConfluenceUser user, AbstractPage page) {
        if (user == null || page == null) {
            return false;
        }
        Label favLabel = new Label("favourite", Namespace.PERSONAL, user);
        Label favYankeeLabel = new Label("favorite", Namespace.PERSONAL, user);
        return page.getLabels().contains(favLabel) || page.getLabels().contains(favYankeeLabel);
    }

    @Override
    public void addPageToFavourites(ConfluenceUser user, AbstractPage page) {
        Preconditions.checkNotNull((Object)page);
        this.checkPermission(user, page);
        Label label = new Label("favourite", Namespace.PERSONAL, user);
        LabelUtil.addLabel(LabelParser.renderWithNamespace(label), this.labelManager, page, user);
    }

    @Override
    public void removePageFromFavourites(ConfluenceUser user, AbstractPage page) {
        Preconditions.checkNotNull((Object)page);
        this.checkPermission(user, page);
        this.removePageFromFavourites(user, page, "favourite");
        this.removePageFromFavourites(user, page, "favorite");
    }

    private void removePageFromFavourites(ConfluenceUser user, AbstractPage page, String labelName) {
        Label label = new Label(labelName, Namespace.PERSONAL, user);
        this.labelManager.removeLabel(page, label);
    }

    @Override
    public boolean hasPermission(ConfluenceUser user, Space space) {
        return this.hasPermissionImpl(user, space.getDescription());
    }

    @Override
    public boolean hasPermission(ConfluenceUser user, AbstractPage page) {
        return this.hasPermissionImpl(user, page);
    }

    private void checkPermission(ConfluenceUser user, SpaceContentEntityObject labelable) {
        if (!this.hasPermissionImpl(user, labelable)) {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            throw new NotAuthorizedException(currentUser != null ? currentUser.getName() : null);
        }
    }

    private boolean hasPermissionImpl(ConfluenceUser user, SpaceContentEntityObject labelable) {
        Label label = new Label("favourite", Namespace.PERSONAL, user);
        return this.labelPermissionEnforcer.userCanEditLabelOrIsSpaceAdmin(label, labelable);
    }
}

