/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.util.sandbox;

import com.atlassian.confluence.impl.util.sandbox.AbstractSandboxPool;
import com.atlassian.confluence.impl.util.sandbox.SandboxLocalProcessPool;
import com.atlassian.confluence.impl.util.sandbox.SandboxPool;
import com.atlassian.confluence.impl.util.sandbox.SandboxPoolConfiguration;
import com.atlassian.confluence.impl.util.sandbox.SandboxPoolFactory;
import com.atlassian.confluence.impl.util.sandbox.SandboxRequest;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

class ConfluenceSandboxPoolFactory
implements SandboxPoolFactory,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceSandboxPoolFactory.class);
    private static final String SANDBOX_POOL_PREFIX = "sandbox";
    @GuardedBy(value="this")
    private final List<SandboxPool> pools = new ArrayList<SandboxPool>();
    private final FilesystemPath sandboxRootDirectoryPath;
    @GuardedBy(value="this")
    private boolean shutdown = false;

    public ConfluenceSandboxPoolFactory(FilesystemPath homeDirectory) {
        this.sandboxRootDirectoryPath = Objects.requireNonNull(homeDirectory).path(new String[]{SANDBOX_POOL_PREFIX});
    }

    @Override
    public SandboxPool create(SandboxPoolConfiguration configuration) {
        return new LazySandboxPool(configuration);
    }

    public void destroy() throws Exception {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        ConfluenceSandboxPoolFactory confluenceSandboxPoolFactory = this;
        synchronized (confluenceSandboxPoolFactory) {
            this.shutdown = true;
            this.pools.forEach(SandboxPool::shutdown);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Thread shutdownThread = new Thread(this::shutdown);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        if (this.sandboxRootDirectoryPath.exists()) {
            FileUtils.cleanDirectory((File)this.sandboxRootDirectoryPath.asJavaFile());
        }
    }

    private synchronized void addPool(AbstractSandboxPool sandboxPool) {
        this.pools.add(sandboxPool);
    }

    class LazySandboxPool
    extends AbstractSandboxPool {
        private final LazyReference<SandboxPool> reference;

        private LazySandboxPool(final SandboxPoolConfiguration configuration) {
            super(configuration);
            final Path workingDirectory = this.prepareWorkingDirectory(ConfluenceSandboxPoolFactory.this.sandboxRootDirectoryPath);
            this.reference = new LazyReference<SandboxPool>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected SandboxPool create() {
                    ConfluenceSandboxPoolFactory confluenceSandboxPoolFactory = ConfluenceSandboxPoolFactory.this;
                    synchronized (confluenceSandboxPoolFactory) {
                        if (ConfluenceSandboxPoolFactory.this.shutdown) {
                            throw new IllegalArgumentException("The service is being shutdown or has been shutdown");
                        }
                        SandboxLocalProcessPool localProcessPool = new SandboxLocalProcessPool(workingDirectory, configuration);
                        ConfluenceSandboxPoolFactory.this.addPool(localProcessPool);
                        return localProcessPool;
                    }
                }
            };
        }

        @Override
        public <T, R> R execute(SandboxRequest<T, R> request) {
            return ((SandboxPool)this.reference.get()).execute(request);
        }

        @Override
        public void shutdown() {
            ((SandboxPool)this.reference.get()).shutdown();
        }

        @Override
        public List<Long> getPids() {
            return ((SandboxPool)this.reference.get()).getPids();
        }

        @Override
        public SandboxPoolConfiguration getConfiguration() {
            return this.configuration;
        }

        private Path prepareWorkingDirectory(FilesystemPath directory) {
            Path workingDirectory;
            try {
                Path directoryPath = directory.asJavaPath();
                Files.createDirectories(directoryPath, new FileAttribute[0]);
                workingDirectory = Files.createTempDirectory(directoryPath, ConfluenceSandboxPoolFactory.SANDBOX_POOL_PREFIX, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return workingDirectory;
        }
    }
}

